// Top Secret Crypto Gold for Windows
//...................................

// Copyright  2000 - 2005 by TAN$TAAFL Software Company
//						      14 Foster St., Banician
//                            Olongapo City 2200
//                            Philippines

// This source code is NOT IN THE PUBLIC DOMAIN and is NOT OPEN SOURCE.
// It is provided solely for the purpose of letting you determine how
// the program works, and that there are no backdoors or hidden code
// in the program. Anyone that wants to use any portion of this code
// in their own program please contact the author at:

//							  MacGregor K. Phillips
//                            PSC 517 Box RS
//                            FPO AP 96517-1000

// Procedures for encrypting a file.
//..................................
#include <windows.h>  
#include "Tsc.h"
#include "ContextHelp.h"
#include "Prototypes.h"
#include <Shlwapi.h>
#include <Commctrl.h>
#include <htmlhelp.h>
#include <shellapi.h>
#include <shlobj.h>
#include "Tscmsg.h"
#include "sha2.h"
#define STRSAFE_LIB
#include <strsafe.h>

extern	DWORD				dwStringSafeFlag;
extern	BOOL				bIsWin95;
extern	HINSTANCE			hInst;
extern	LPCTSTR				lpszAppName;
extern	LPCTSTR				lpKeyRingIcon;
extern	TCHAR				szPassPhrase1[250];
extern	LPCTSTR				lpszNullString;
extern	LPTSTR				lpszNA;
extern	LPCTSTR				lpIconPointer;
extern	BOOL				bProcessInProgress;
extern	HWND				hMainWindow;
extern	TCHAR				szDestination[MAX_PATH];
extern	LPBYTE				lpKeyBuffer1;
extern	LPBYTE				lpKeyBuffer2;
extern	LPBYTE				lpKeyBuffer3;
extern	LPCD_STRUCT			lpPublicKeyCentralDir;
extern	LPCD_STRUCT			lpSecretKeyCentralDir;
extern	LPCD_STRUCT			lpScratchCentralDir;
extern	LPCD_STRUCT			lpScratchCentralDir1;
extern	DWORD				dwSecretIds;
extern	DWORD				dwPublicIds;
extern	BYTE				KeySID;
extern	LPBYTE				lpRingFile2;
extern	LPBYTE				lpIndexFile1;
extern	LPBYTE				lpIndexFile2;
extern	HANDLE				hIdxHandle1;
extern	HANDLE				hIdxHandle2;
extern	SEARCH_TEMPLATE		KeyIdSearch;
extern	TCHAR				szYes;
extern	DWORD				dwIdxOffset2;
extern	DWORD				dwIdxOffset1;
extern	DWORD				dwEditFunction;
extern	DWORD				MarkType;
extern	BOOL				bSingleSelectionOnly;
extern	int					iItemCount;
extern	int					iItemsSelected;
extern	int					iMaxItems;
extern	DWORD				dwCDLength;
extern	CD_STRUCT			CDLine;
extern	CD_STRUCT			CDLine1;
extern	BYTE				UserId[256];
extern	BYTE				TempUserId[256];
extern	TCHAR				Key58;
extern	TCHAR				Key31;
extern	TCHAR				Key32;
extern	LPBYTE				lpFileName;
extern	LPBYTE				lpFileExtension;
extern	HICON				hIcon;
extern	DWORD				dwN_Bytes;
extern	HHOOK				hHook;
extern	HHOOK				hMouseHook;
extern	DWORD				Seed;
extern	BOOL				bCancelOperation;
extern	HANDLE				hDialogModeLess;
extern	HANDLE				hDlgCurrent;
extern	WORD				Mod_N_Mpi;
extern	BYTE				Modulus_N[MAX_MOD_SLOP];
extern	WORD				E_Mpi;
extern	BYTE				E_Temp[MAX_MOD_SLOP];
extern	DWORD				dwE_Bytes;
extern	BYTE				Temp1;
extern	DWORD				dwCountBits;
extern	DWORD				dwCountBytes;
extern	BYTE				Md5Digest[MD5_DIGEST_SIZE];
extern	BYTE				D_Temp[MAX_MOD_SLOP];
extern	BYTE				Prime_P[MAX_PRIME_SLOP];
extern	BYTE				Prime_Q[MAX_PRIME_SLOP];
extern	BYTE				U_Temp[MAX_MOD_SLOP];
extern	DWORD				TopsArray[256];
extern	DWORD				FactorArray[256];
extern	DWORD				SeedsArray[256];
extern	BYTE				LastSeed;
extern	DWORD				DbleNumber;
extern	DWORD				Divisor1;
extern	int					iSkipCounter;
extern	int					iInitialSkipValue;
extern	BYTE				RingMask;
extern	UINT				uTimer;
extern	DWORD				dwElapHours;
extern	DWORD				dwElapMinutes;
extern	DWORD				dwElapSeconds;
extern	HWND				hStatusBar;
extern	BOOL				bDisplayRingsOnStatusBar;
extern	TCHAR				szStatusBarRings[127];
extern	SHFILEINFO			shfi1;
extern	SHFILEINFO			shfi2;
extern	TCHAR				szOtpKeyFile[MAX_PATH];
extern	BOOL				bCanceledMsgEncryption;
extern	BOOL				bUseNew;
extern	BOOL				bUseMd5;
extern	BYTE				ShaDigest[SHA_DIGEST_SIZE];
extern	BYTE				Sha512Digest[SHA512_DIGEST_SIZE];
extern	BOOL				bWipeFiles;
extern	BOOL				bNeedDestination;
extern	BOOL				bAa;
extern	BOOL				bRestrictionsInEffect;
extern	TCHAR				szPreviousSourceDir[MAX_PATH];
extern	int					iFilesWiped;
extern	BOOL				bEncryptIt;
extern	BOOL				bAlreadyPacked;
extern	LPBYTE				lpKeyBufferDup1;
extern	LPBYTE				lpKeyBufferDup2;
extern	HFONT				hDlgFont;
extern	BOOL				bWin2000OrGreater;
extern	COLORREF			crClassification;
extern	BOOL				bEncryptingEmail;
extern	CONFIG				cfg;

// Classification strings.
//........................
TCHAR				szTscYEO[] = "TOP SECRET - FOR YOUR EYES ONLY!";
TCHAR				szTscDAR[] = "TOP SECRET - DESTROY AFTER READING!";
TCHAR				szTscTS[] = "TOP SECRET";
TCHAR				szMySecret[] = "SECRET";
TCHAR				szConfidential[] = "CONFIDENTIAL";
TCHAR				szForOfficialUseOnly[] = "FOR OFFICIAL USE ONLY";
TCHAR				szUnClassified[] = "UNCLASSIFIED";

LPTSTR				lpClassifications[] = {(LPTSTR)&szTscYEO,(LPTSTR)&szTscDAR,
										   (LPTSTR)&szTscTS, (LPTSTR)&szMySecret,
										   (LPTSTR)&szConfidential,
										   (LPTSTR)&szForOfficialUseOnly,
										   (LPTSTR)&szUnClassified};

HANDLE				hSpecialInst;
DWORD				dwSelection;

// Variables for enciphering and deciphering a file.
//..................................................
NONREPRO_HDR		nrphdr;
NONREPRO_PADHDR		nrppadhdr;
PKEY_HDR			pkh;
SKEY_HDR			skh;
CKEY_HDR			ckh;
FILE_INFO_PCKT		fip;

// Reproducible session key header variables.
//...........................................
BYTE				rphdr[MAX_REPRO_LGTH];

DWORD				dwReproLength;
LPBYTE				lpCsumOffset;
LPBYTE				lpSeedOffset;
LPBYTE				lpEncryptedFileName;
DWORD				dwRngsUsed;
DWORD				dwSeedsNeeded;
DWORD				dwSmallestKey;
TCHAR				szEncFileExtension[] = ".tsc";
TCHAR				szFileToEncipher[MAX_PATH];
TCHAR				szRecipient[MAX_PATH];
DWORD				dwUseSessionKey;
LARGE_INTEGER		liEncFileSize;
OPENFILENAME		ofnEncrypt;
LPBYTE				lpFolderFiles;
BOOL				bShowPreviousEncFolder;

// The following are always FALSE unless set to TRUE.
//...................................................
BOOL				bWipeAfterEncryption = FALSE;
BOOL				bWipeOTPFileAfterUse = FALSE;
BOOL				bWipeTrueOTPFileAfterUse = FALSE;
BOOL				bPackingRequired = FALSE;
BOOL				bIntermediatePkd = FALSE;
BOOL				bWipeIntermediate = FALSE;

// Folder operations.
//...................
VOID FolderOps(DWORD dwOps)
{
	BROWSEINFO			bi;
    LPITEMIDLIST		lpidl;
    LPMALLOC			lpMalloc;
	BOOL				bResult;
	OPENFILENAME		ofn;
	HANDLE				hSearch = 0;
	WIN32_FIND_DATA		wfd;
	DWORD				dwOldHelpTopic = 0;
	int					i;
	int					iResult;
	BOOL				bWipeOriginals;
	BOOL				bError;
	LPBYTE				lpFileNames = 0;
	LPTSTR				lpBackNull;
	LPBYTE				lpCopyPoint;
	DWORD				dwTotalLength = 0;
	DWORD				dwFileCount = 0;
	DWORD				dwFolderCount = 0;
	DWORD				dwError;
	int					iCompareResult;
	HRESULT				hr = ERROR_SUCCESS;
	TCHAR				szDirectoryName[MAX_PATH];
	TCHAR				szTemplate[512];
	TCHAR				szBuffer[1024];
	TCHAR				szLastFileName[MAX_PATH];
	TCHAR				szCurrentDir[MAX_PATH];

	bProcessInProgress = TRUE;

	// Initialize the OPENFILENAME structure.
	//.......................................
	InitializeOFN(&ofn,SAVE_SOURCE);
	iFilesWiped = 0;

	// Set the current directory.
	//...........................
	SetCurrentDirectory((LPCTSTR)&szPreviousSourceDir);

	// Browse for a folder to encrypt.
	//................................
	ZeroMemory(&szDestination,sizeof(szDestination));

	if (SUCCEEDED(SHGetMalloc(&lpMalloc))) 
	{
		ZeroMemory(&bi,sizeof(bi));
		bi.hwndOwner = hMainWindow;
		bi.pszDisplayName = 0;
		
		// Setup the correct title for the dialog box.
		//............................................
		if (dwOps == IDM_ENC_FOLDER)
		{
			bi.lpszTitle = TEXT("Select a folder to compress and encrypt all its files.");
			dwOldHelpTopic = ChangeHelpTopic(IDH_ENC_FOLDER);
		}
		else if (dwOps == IDM_PACK_FOLDER)
		{
			bi.lpszTitle = TEXT("Select a folder to compress all its files.");
			dwOldHelpTopic = ChangeHelpTopic(IDH_PACK_FOLDER);
		}
		else if (dwOps == IDM_WIPE_FOLDER)
		{
			bi.lpszTitle = TEXT("Select a folder to wipe all its files.");
			dwOldHelpTopic = ChangeHelpTopic(IDH_WIPE_FOLDER);
		}
		else if (dwOps == IDM_DELETE_FOLDER)
		{
			bi.lpszTitle = TEXT("Select a Folder to delete all its files.");
			dwOldHelpTopic = ChangeHelpTopic(IDH_DELETE_FOLDER);
		}
		else
		{
			goto FolderEnd;
		}
		bi.pidlRoot = 0;
		bi.ulFlags = BIF_RETURNONLYFSDIRS | BIF_BROWSEINCLUDEFILES;

		// If we can use the new style of the dialog box, do it.
		//......................................................
		if (bUseNew)
		{
			hr = CoInitialize(NULL);
			if (SUCCEEDED(hr))
			{
				bi.ulFlags |= BIF_NEWDIALOGSTYLE;
			}
		}
		bi.lpfn = BrowseCallbackProc;

		lpidl = SHBrowseForFolder(&bi);

		if (bUseNew && SUCCEEDED(hr))
		{
			CoUninitialize();
		}
		if (lpidl) 
		{
			bResult = SHGetPathFromIDList(lpidl,(LPSTR)&szDestination);
			lpMalloc->lpVtbl->Free(lpMalloc,lpidl);
			lpMalloc->lpVtbl->Release(lpMalloc);
		}
		else
		{
			// We cancelled out.
			//..................
			goto FolderEnd;
		}		
	}
	else
	{
		MessageBoxProc(hMainWindow,IDS_SYSTEM_ERROR,IDS_SELECTDIR,
					   MB_ICONHAND | MB_OK,MB_ICONHAND,0);
		goto FolderEnd;
	}
	// Remove any file name that may be with the selected directory.
	//..............................................................
	if (!PathIsDirectory((LPCTSTR)&szDestination))
	{
		PathRemoveFileSpec((LPTSTR)&szDestination);
	}
	SaveDirName((LPBYTE)&szDestination,SAVE_SOURCE,FALSE);
	CopyMemory(&szDirectoryName,&szDestination,MAX_PATH);

	i = lstrlen((LPCTSTR)&szDestination);
	ofn.nFileOffset = (i + 1);

	dwTotalLength = ofn.nFileOffset;

	// Add a backslash and wide card characters to search for all files.
	//..................................................................
	lpBackNull = PathAddBackslash((LPTSTR)&szDestination);
	StringCbCatEx((LPTSTR)&szDestination,sizeof(szDestination),(LPCTSTR)TEXT("*.*"),NULL,
				   NULL,dwStringSafeFlag);

	// We now have to build the string of files names to pass to the
	// compression and encryption procedures.
	//..............................................................
	hSearch = FindFirstFile((LPCTSTR)&szDestination,&wfd);
	if (hSearch == INVALID_HANDLE_VALUE)
	{
		ErrorProcedure((LPTSTR)&szDestination,IDS_FINDFIRSTFILE,MB_OK);
		goto FolderEnd;
	}
	// Search for the rest of the files to determine the total number of
	// files and the size of the file names.
	//..................................................................
	while(TRUE)
	{
		if (wfd.dwFileAttributes & FILE_ATTRIBUTE_DIRECTORY)
		{
			dwFolderCount++;
		}
		else
		{
			dwFileCount++;
			dwTotalLength += lstrlen((LPCTSTR)&wfd.cFileName);
			dwTotalLength++;
			CopyMemory(&szLastFileName,&wfd.cFileName,MAX_PATH);
		}
		bResult = FindNextFile(hSearch,&wfd);
		if (!bResult)
		{
			dwError = GetLastError();
			if (dwError ==  ERROR_NO_MORE_FILES)
			{
				break;
			}
			SetLastError(dwError);
			ErrorProcedure((LPTSTR)&szDestination,IDS_FINDNEXTFILE,MB_OK);
			goto FolderEnd;
		}
	}
	if (hSearch)
	{
		FindClose(hSearch);
		hSearch = 0;
	}
	// We have the file count and amount of memory we need.
	// Build the file name string for passing to the encryption and compression
	// procedure.
	//.........................................................................
	dwTotalLength += 1024;
	lpFileNames = AllocateMemory(dwTotalLength);
	if (!lpFileNames)
	{
		goto FolderEnd;
	}
	StringCbCatEx((LPTSTR)lpFileNames,dwTotalLength,(LPCTSTR)&szDestination,NULL,NULL,
				   dwStringSafeFlag);

	// If we only have one file create the file name.
	//...............................................
	if (dwFileCount == 1)
	{
		PathRemoveFileSpec((LPTSTR)lpFileNames);
		lpCopyPoint = PathAddBackslash((LPTSTR)lpFileNames);
		ofn.nFileOffset = lpCopyPoint - lpFileNames;
		StringCbCatEx((LPTSTR)lpFileNames,dwTotalLength,(LPCTSTR)&szLastFileName,NULL,
					   NULL,dwStringSafeFlag);
	}
	else if (dwFileCount > 1)
	{
		lpCopyPoint = lpFileNames;
		lpCopyPoint += ofn.nFileOffset;
		lpCopyPoint--;
		ZeroMemory(lpCopyPoint,16);
		lpCopyPoint++;

		// Build the list of file names.
		//..............................
		hSearch = FindFirstFile((LPCTSTR)&szDestination,&wfd);
		if (hSearch == INVALID_HANDLE_VALUE)
		{
			ErrorProcedure((LPTSTR)&szDestination,IDS_FINDFIRSTFILE,MB_OK);
			goto FolderEnd;
		}
		// Search for the rest of the files to determine the total number of
		// files and the size of the file names.
		//..................................................................
		while(TRUE)
		{
			if (!(wfd.dwFileAttributes & FILE_ATTRIBUTE_DIRECTORY))
			{
				CopyMemory(lpCopyPoint,&wfd.cFileName,lstrlen((LPCTSTR)&wfd.cFileName));
				lpCopyPoint += lstrlen((LPCTSTR)&wfd.cFileName);
				lpCopyPoint++;
			}
			bResult = FindNextFile(hSearch,&wfd);
			if (!bResult)
			{
				dwError = GetLastError();
				if (dwError ==  ERROR_NO_MORE_FILES)
				{
					break;
				}
				SetLastError(dwError);
				ErrorProcedure((LPTSTR)&szDestination,IDS_FINDNEXTFILE,MB_OK);
				goto FolderEnd;
			}
		}
	}
	if (dwOps == IDM_WIPE_FOLDER)
	{
		if (dwFileCount > 0)
		{
			bWipeFiles = TRUE;
			DeleteWipeFiles(lpFileNames,&ofn);
		}
		dwFileCount -= iFilesWiped;
		if (dwFileCount == 0 && dwFolderCount <= 2)
		{
			// See if we want to delete the folder.
			//.....................................
			LoadString(hInst,IDS_DELETEMYFOLDER,(LPTSTR)&szTemplate,sizeof(szTemplate));
			StringCbPrintf((LPTSTR)&szBuffer,sizeof(szBuffer),(LPCTSTR)&szTemplate,
							szDirectoryName);
			iResult = MessageBoxProc(hMainWindow,IDS_QUESTION,(UINT)szBuffer,
									 MB_ICONQUESTION | MB_YESNO | MB_HELP,MB_ICONQUESTION,0);
			if (iResult == IDYES)
			{
				GetCurrentDirectory(MAX_PATH,(LPTSTR)&szCurrentDir);
				iCompareResult = CompareString(LOCALE_USER_DEFAULT,0,
											  (LPCTSTR)&szCurrentDir,-1,
											  (LPCTSTR)&szDirectoryName,-1);
				if (iCompareResult == CSTR_EQUAL)
				{
					// We cannot delete the current directory.
					//........................................
					SetLastError(IDS_NODELCURRENTDIR);
					ErrorProcedure((LPTSTR)&szDirectoryName,IDS_REMOVEDIR,MB_OK);
					goto FolderEnd;
				}
				bResult = RemoveDirectory((LPCTSTR)&szDirectoryName);
				if (!bResult)
				{
					ErrorProcedure((LPTSTR)&szDirectoryName,IDS_REMOVEDIR,MB_OK);
				}
				else
				{
					LoadString(hInst,IDS_DIRREMOVED,(LPTSTR)&szTemplate,sizeof(szTemplate));
					StringCbPrintf((LPTSTR)&szBuffer,sizeof(szBuffer),(LPCTSTR)&szTemplate,
								    szDirectoryName);
					MessageBoxProc(hMainWindow,IDS_ADVISORY,(UINT)szBuffer,
								   MB_ICONINFORMATION | MB_OK,MB_ICONINFORMATION,0);
				}
			}
		}
		else if (dwFileCount == 0 && dwFolderCount > 2)
		{
			LoadString(hInst,IDS_NOFILESSUBS,(LPTSTR)&szTemplate,sizeof(szTemplate));
			StringCbPrintf((LPTSTR)&szBuffer,sizeof(szBuffer),(LPCTSTR)&szTemplate,
							szDirectoryName);
			MessageBoxProc(hMainWindow,IDS_ADVISORY,(UINT)szBuffer,
						   MB_ICONINFORMATION | MB_OK | MB_HELP,MB_ICONINFORMATION,0);
		}
	}
	else if (dwOps == IDM_DELETE_FOLDER)
	{
		if (dwFileCount > 0)
		{
			bWipeFiles = FALSE;
			DeleteWipeFiles(lpFileNames,&ofn);
		}
		dwFileCount -= iFilesWiped;
		if (dwFileCount == 0 && dwFolderCount <= 2)
		{
			// See if we want to delete the folder.
			//.....................................
			LoadString(hInst,IDS_DELETEMYFOLDER,(LPTSTR)&szTemplate,sizeof(szTemplate));
			StringCbPrintf((LPTSTR)&szBuffer,sizeof(szBuffer),(LPCTSTR)&szTemplate,
							szDirectoryName);
			iResult = MessageBoxProc(hMainWindow,IDS_QUESTION,(UINT)szBuffer,
									 MB_ICONQUESTION | MB_YESNO | MB_HELP,MB_ICONQUESTION,0);
			if (iResult == IDYES)
			{
				GetCurrentDirectory(MAX_PATH,(LPTSTR)&szCurrentDir);
				iCompareResult = CompareString(LOCALE_USER_DEFAULT,0,
											  (LPCTSTR)&szCurrentDir,-1,
											  (LPCTSTR)&szDirectoryName,-1);
				if (iCompareResult == CSTR_EQUAL)
				{
					// We cannot delete the current directory.
					//........................................
					SetLastError(IDS_NODELCURRENTDIR);
					ErrorProcedure((LPTSTR)&szDirectoryName,IDS_REMOVEDIR,MB_OK);
					goto FolderEnd;
				}
				bResult = RemoveDirectory((LPCTSTR)&szDirectoryName);
				if (!bResult)
				{
					ErrorProcedure((LPTSTR)&szDirectoryName,IDS_REMOVEDIR,MB_OK);
				}
				else
				{
					LoadString(hInst,IDS_DIRREMOVED,(LPTSTR)&szTemplate,sizeof(szTemplate));
					StringCbPrintf((LPTSTR)&szBuffer,sizeof(szBuffer),(LPCTSTR)&szTemplate,
									szDirectoryName);
					MessageBoxProc(hMainWindow,IDS_ADVISORY,(UINT)szBuffer,
								   MB_ICONINFORMATION | MB_OK,MB_ICONINFORMATION,0);
				}
			}
		}
		else if (dwFileCount == 0 && dwFolderCount > 2)
		{
			LoadString(hInst,IDS_NOFILESSUBS,(LPTSTR)&szTemplate,sizeof(szTemplate));
			StringCbPrintf((LPTSTR)&szBuffer,sizeof(szBuffer),(LPCTSTR)&szTemplate,
							szDirectoryName);
			MessageBoxProc(hMainWindow,IDS_ADVISORY,(UINT)szBuffer,
						   MB_ICONINFORMATION | MB_OK | MB_HELP,MB_ICONINFORMATION,0);
		}
	}
	else if (dwOps == IDM_ENC_FOLDER)
	{
		if (dwFileCount > 0)
		{
			bWipeOriginals = FALSE;
			bWipeIntermediate = TRUE;
			LoadString(hInst,IDS_ENCDELETEORIG,(LPTSTR)&szTemplate,sizeof(szTemplate));
			StringCbPrintf((LPTSTR)&szBuffer,sizeof(szBuffer),(LPCTSTR)&szTemplate,
							szDirectoryName);
			iResult = MessageBoxProc(hMainWindow,IDS_QUESTION,(UINT)szBuffer,
									 MB_ICONQUESTION | MB_YESNOCANCEL | MB_HELP,
									 MB_ICONQUESTION,0);
			if (iResult == IDCANCEL)
			{
				goto FolderEnd;
			}
			else if (iResult == IDYES)
			{
				bWipeOriginals = TRUE;
			}
			bNeedDestination = TRUE;
			bPackingRequired = TRUE;
			bWipeIntermediate = TRUE;
			bError = EncryptAFile(lpFileNames,&ofn);
			if (!bError && bWipeOriginals)
			{
				// Wipe the original files.
				//.........................
				bWipeFiles = TRUE;
				DeleteWipeFiles(lpFileNames,&ofn);
			}
		}
		else
		{
			LoadString(hInst,IDS_NOFOLDERENC,(LPTSTR)&szTemplate,sizeof(szTemplate));
			StringCbPrintf((LPTSTR)&szBuffer,sizeof(szBuffer),(LPCTSTR)&szTemplate,
						    szDirectoryName);
			MessageBoxProc(hMainWindow,IDS_ADVISORY,(UINT)szBuffer,MB_ICONINFORMATION | MB_OK,
						   MB_ICONINFORMATION,0);
		}
	}
	else if (dwOps == IDM_PACK_FOLDER)
	{
		if (dwFileCount > 0)
		{
			bWipeOriginals = FALSE;
			LoadString(hInst,IDS_PACKDELINTERM,(LPTSTR)&szTemplate,sizeof(szTemplate));
			StringCbPrintf((LPTSTR)&szBuffer,sizeof(szBuffer),(LPCTSTR)&szTemplate,
							szDirectoryName);
			iResult = MessageBoxProc(hMainWindow,IDS_QUESTION,(UINT)szBuffer,
									 MB_ICONQUESTION | MB_HELP | MB_YESNOCANCEL,
									 MB_ICONQUESTION,0);
			if (iResult == IDCANCEL)
			{
				goto FolderEnd;
			}
			else if (iResult == IDYES)
			{
				bWipeOriginals = TRUE;
			}
			bNeedDestination = TRUE;
			
			// Pack the files.
			//................
			bEncryptIt = FALSE;
			bError = PackFiles(lpFileNames,&ofn);
			if (bError)
			{
				goto FolderEnd;
			}
			if (bWipeOriginals)
			{
				bWipeFiles = TRUE;
				DeleteWipeFiles(lpFileNames,&ofn);
			}
		}
		else
		{
			LoadString(hInst,IDS_NOFOLDERPACK,(LPTSTR)&szTemplate,sizeof(szTemplate));
			StringCbPrintf((LPTSTR)&szBuffer,sizeof(szBuffer),(LPCTSTR)&szTemplate,
							szDirectoryName);
			MessageBoxProc(hMainWindow,IDS_ADVISORY,(UINT)szBuffer,
						   MB_ICONINFORMATION | MB_OK,MB_ICONINFORMATION,0);
		}
	}

	FolderEnd:

	if (lpFileNames)
	{
		ZeroMemory(lpFileNames,dwTotalLength);
		DeallocateMemory(lpFileNames);
	}
	if (hSearch)
	{
		FindClose(hSearch);
	}
	if (dwOldHelpTopic)
	{
		ChangeHelpTopic(dwOldHelpTopic);
	}
	bNeedDestination = FALSE;
	bPackingRequired = FALSE;
	bProcessInProgress = FALSE;
}

// Encrypt a file. If parameters are not blank, we are calling from
// either encrypt an e-mail message or add attachments.
//.................................................................
BOOL EncryptAFile(LPBYTE lpBuffer, LPOPENFILENAME lpofn)
{
	HANDLE			hFileToEncipher = 0;
	HANDLE			hEncryptedFile = 0;
	BOOL			bOutPutError = TRUE;
	HANDLE			hOtpKeyFile = 0;
	LARGE_INTEGER	li;
	LARGE_INTEGER	liPadFreeBytes;
	ULARGE_INTEGER	uliTemp;
	LARGE_INTEGER	liCurrentTimestamp;
	LARGE_INTEGER	liRecipientsTimestamp;
	LARGE_INTEGER	liStartPosition;
	LARGE_INTEGER	liWipeLength;
	OPENFILENAME	ofn;
	LPBYTE			lpTempEDI;
	LPBYTE			lpUserId;
	LPBYTE			lpKeyLegit;
	LPBYTE			lpFileReturn;
	LPBYTE			lpTempHeader;
	LPTSTR			lpOtpFileName;
	DWORD			dwSeedsNeededDup;
	DWORD			dwUserIdLength;
	DWORD			dwOldHelpTopic;
	DWORD			dwCheckSum;
	DWORD			dwSecretElements;
	DWORD			dwCDStructLength;
	DWORD			dwBytesRead;
	DWORD			dwBytesWritten;
	DWORD			dwCtb_Byte;
	DWORD			dwTempEAX;
	DWORD			dwEncModNBytes;
	int				iRecipients;
	int				iCompareResult;
	int				iResult;
	BOOL			bResult;
	BOOL			bError;
	BOOL			bKeyDisabled;
	BYTE			KeyLegit;
	BYTE			TempCTB;
	TCHAR			szOutBuffer[768];
	TCHAR			szFormatBuffer[512];
	HRESULT			hr = ERROR_SUCCESS;

	// We have a process in progress.
	//...............................
	bProcessInProgress = TRUE;
	bAlreadyPacked = FALSE;

	// Signal for cancelling encryption of an e-mail message.
	//.......................................................
	bCanceledMsgEncryption = FALSE;

	dwCDLength = sizeof(CD_STRUCT);

	dwOldHelpTopic = ChangeHelpTopic(IDH_ENCIPHER);

	if (BPC())
	{
		goto EncipherEnd;
	}
	// Setup the skip counters for the CheckForMessages function.
	//...........................................................
	__asm
	{
		mov		iSkipCounter,250
		mov		iInitialSkipValue,250
	}
	// Clear all the variables we will be using.
	//..........................................
	ClearAllVariables();
	ClearMathVariables();

	// Setup our structures for the various headers, etc.
	//...................................................
	ZeroMemory(&nrphdr.LONG_FILE_NAME,sizeof(nrphdr.LONG_FILE_NAME));
	ZeroMemory(&nrppadhdr.LONG_FILE_NAME,sizeof(nrppadhdr.LONG_FILE_NAME));
	ZeroMemory(&rphdr,MAX_REPRO_LGTH);

	// Setup the public key encryption header.
	//........................................
	pkh.CTB = (CTB_PKE_PACKET | LENGTH_2);
	pkh.VERSION = VERSION_NEW;
	pkh.RSA_ALGOR = RSA_ALGORITHM;

	// Setup the secret key signature packet header.
	//..............................................
	skh.CTB = (CTB_SKE_PACKET | LENGTH_2);
	skh.VERSION = VERSION_NEW;
	skh.CLASS = SIG_MSG_BINARY;
	skh.RSA_ALGOR = RSA_ALGORITHM;
	
	// Setup the conventional key encrypted packet header.
	//....................................................
	ckh.CTB = (CTB_CKE_PCKT | LENGTH_8);

	// Initialize the OPENFILENAME structure.
	//.......................................
	InitializeOFN(&ofn,SAVE_SOURCE);
	bWipeIntermediate = TRUE;

	// If we are not passing parameters in from another procedure we
	// have to get the list of files outselves.
	//..............................................................
	if (!lpBuffer)
	{
		// Allocate the memory for the return file buffer. This is
		// the maximum sized buffer that the GetOpenFileName common
		// dialog box procedure can handle.
		//.........................................................
		lpFileReturn = AllocateMemory((64 * 1024)-1);
		if (!lpFileReturn)
		{
			goto EncipherEnd;
		}
		// Initialize with specific information for this procedure.
		//.........................................................
		ofn.lpstrFile = lpFileReturn;
		ofn.nMaxFile = ((64 * 1024)-1);
		ofn.hwndOwner = hMainWindow;
		ofn.lpstrFilter = TEXT("All Files [*.*]\0*.*\0Compressed Files [.pkd;.lha;.zip;.arj;.cab]\0*.pkd;*.lha;*.zip;*.arj;*.cab\0Adobe PDF Files [.pdf]\0*.pdf\0Executable Files [.exe;.dll;.ocx]\0*.exe;*.dll;*.ocx\0Image Files [.bmp;.dib;.gif;.jpg;,ico;,cur]\0*.bmp;*.dib;*.gif;*.jpg;*.ico;*.cur\0Word Documents [.doc]\0*.doc\0Web Pages [.htm;.html;.mht]\0*.htm;*.html;*.mht\0Email Files [.eml]\0*.eml\0Rich Text Format [.rtf]\0*.rtf\0Text Files [.txt]\0*.txt\0Lotus 1-2-3 [.wk1;.wk3]\0*.wk1;*.wk3\0Microsoft Excel Worksheet [.xls;.xlw]\0*.xls;*.xlw\0Windows Write [.wri]\0*.wri\0WordPerfect 5.x [.doc]\0*.doc\0WordPerfect 6.x [.wpd;.doc]\0*.wpd;*.doc\0Tscg Files [.rng;.rsakey;.tsc;.otp;.pad;.tsig;.jrl]\0*.rng;*.rsakey;*.tsc;*.otp;*.pad;*.tsig;*.jrl\0");
		ofn.nFilterIndex = 1;
		ofn.lpstrTitle = TEXT("Select One or More Files to Compress and Encipher");
		ofn.Flags = (OFN_EXPLORER | OFN_FILEMUSTEXIST | OFN_PATHMUSTEXIST |
					 OFN_ENABLEHOOK | OFN_ENABLESIZING | OFN_HIDEREADONLY |
					 OFN_SHOWHELP | OFN_ALLOWMULTISELECT);
		ofn.lpstrDefExt = NULL;

		// Allow wipe original if no admin account or admin allows it.
		//............................................................
		if (!bAa || (bAa && (cfg.V1.dwV3 & PERMIT_WIPE_ORIGINAL)) || 
		   (bAa && !bRestrictionsInEffect))
		{
			if (bWin2000OrGreater)
			{
				ofn.lpTemplateName = TEXT("WIPEAFTERENCRYPTIONNEW");
			}
			else
			{
				ofn.lpTemplateName = TEXT("WIPEAFTERENCRYPTION");
			}
			ofn.lpfnHook = MyEncOFNHookProc;
			ofn.Flags |= OFN_ENABLETEMPLATE;
			ofn.hInstance = hInst;
		}
		else
		{
			ofn.lpfnHook = MyOFNHookProc;
		}
		// Setup the icon to use in the caption bar.
		//..........................................
		lpIconPointer = lpszAppName;

		if (!GetOpenFileName(&ofn))
		{
			CommDlgBoxErrorProc(IDS_GET_FILES);
			goto EncipherEnd;
		}
		bNeedDestination = TRUE;
		bPackingRequired = TRUE;
	}
	else
	{
		// Setup the file names and ofn structure that we want to pack and
		// encipher the other procedure.
		//................................................................
		lpFileReturn = lpBuffer;
		CopyMemory(&ofn,lpofn,sizeof(OPENFILENAME));
	}
	// Save a copy of the ofn structure.
	//..................................
	CopyMemory(&ofnEncrypt,&ofn,sizeof(OPENFILENAME));

	// Send our parameters to the pack files procedure.
	// Returns packed file in szDestination.
	//.................................................
	if (bPackingRequired)
	{
		bIntermediatePkd = TRUE;
		bError = PackFiles(lpFileReturn,&ofn);
		if (bError)
		{
			goto EncipherEnd;
		}
		bPackingRequired = FALSE;

		if (bAlreadyPacked)
		{
			// We have only one file and it is packed. Copy lpFileReturn
			// to file to encipher.
			//..........................................................
			CopyMemory(&szFileToEncipher,lpFileReturn,MAX_PATH);
		}
		else
		{
			// The packed file will now be the one we encrypt.
			//................................................
			CopyMemory(&szFileToEncipher,&szDestination,MAX_PATH);
		}
	}
	else
	{
		CopyMemory(&szDestination,&szFileToEncipher,MAX_PATH);
	}
	// Get a pointer to the file name and file extension if
	// we need it later.
	//.....................................................
	lpFileExtension = PathFindExtension((LPCTSTR)szFileToEncipher);
	lpFileName = PathFindFileName((LPCTSTR)szFileToEncipher);

	// If we have a zero length file we cannot encrypt it.
	//....................................................
	if (liEncFileSize.QuadPart == 0)
	{
		SetLastError(IDS_ENCIPHERLENGTHOFZERO);
		ErrorProcedure((LPTSTR)&szFileToEncipher,IDS_GETFILESIZE,MB_OK);
		goto EncipherEnd;
	}
	// Setup the file information packet with information about the file.
	// We will fill in the file time variables when we open the file.
	//...................................................................
	fip.CTB = (CTB_FILE_INFO | LENGTH_2);
	fip.LENGTH = (sizeof(fip) - 3);
	__asm
	{
		mov		ax,fip.LENGTH
		xchg	ah,al
		mov		fip.LENGTH,ax
	}
	ZeroMemory(&fip.FILE_NAME,sizeof(fip.FILE_NAME));
	CopyMemory(&fip.FILE_NAME,lpFileName,lstrlen((LPCTSTR)lpFileName));
	fip.ATTRIBUTES = GetFileAttributes((LPCTSTR)&szFileToEncipher);
	if (fip.ATTRIBUTES == 0xffffffff)
	{
		ErrorProcedure((LPTSTR)&szFileToEncipher,IDS_GETFILEATTR,MB_OK);
		goto EncipherEnd;
	}
	fip.TERMINATION = 0;

	EmptyTheMessageQue();

	// Create our destination specification.
	//......................................
	PathRemoveExtension((LPTSTR)&szDestination);
	StringCbCatEx((LPTSTR)&szDestination,sizeof(szDestination),(LPCTSTR)&szEncFileExtension,
				   NULL,NULL,dwStringSafeFlag);

	// Setup a pointer to the encrypted file name.
	//............................................
	lpEncryptedFileName = PathFindFileName((LPCTSTR)&szDestination);

	// Allocate memory for the three buffers we will use and the
	// central directories for the public and secret key rings.
	//..........................................................
	dwSecretElements = dwSecretIds;
	dwCDStructLength = sizeof(CD_STRUCT);

	lpKeyBuffer1 = AllocateMemory(SIZE_KEY_BUFF);
	lpKeyBuffer2 = AllocateMemory(SIZE_KEY_BUFF);
	lpKeyBuffer3 = AllocateMemory(SIZE_KEY_BUFF);
	lpSecretKeyCentralDir = AllocateMemory(dwSecretIds * sizeof(CD_STRUCT));
	lpPublicKeyCentralDir = AllocateMemory(dwPublicIds * sizeof(CD_STRUCT));

	if (!lpKeyBuffer1 || !lpKeyBuffer2 || !lpKeyBuffer3 ||
		!lpSecretKeyCentralDir || !lpPublicKeyCentralDir)
	{
		goto EncipherEnd;
	}
	// Build the central directory for the secret key ring.
	// Use the user id index in group one to keep the keys
	// in order. 
	//....................................................
	SetUpGroup(SECRET_KEY,INDEX_UID,GROUP_ONE);
	bResult = BuildCentralDirectory(lpSecretKeyCentralDir,FALSE);
	if (!bResult)
	{
		goto EncipherEnd;
	}
	// Build the central directory for the public key ring.
	// Use the user id index in group one to keep the keys
	// in order. Use group two for the key id index.
	//.....................................................
	SetUpGroup(PUBLIC_KEY,INDEX_UID,GROUP_ONE);
	SetUpGroup(PUBLIC_KEY,INDEX_KEY,GROUP_TWO);
	bResult = BuildCentralDirectory(lpPublicKeyCentralDir,FALSE);
	if (!bResult)
	{
		goto EncipherEnd;
	}
	// Make a quick check to mark the secret keys as disabled or not.
	//...............................................................
	lpScratchCentralDir = lpSecretKeyCentralDir;
	while(dwSecretElements != 0)
	{
		// Search for the corresponding public key so we can check
		// if the secret key is disabled.
		//........................................................
		CopyMemory(&KeySID,lpScratchCentralDir->KEY_SIG_ID,KEY_ID_SIZE);

		li.QuadPart = SearchMyFileBinary(lpIndexFile2,&KeySID,KEY_ID_SIZE,hIdxHandle2,
										 0,&KeyIdSearch);
		if (li.QuadPart == -1)
		{
			goto EncipherEnd;
		}
		if (li.QuadPart != 0)
		{
			// We had a match. See if the public/secret key pair
			// is disabled.
			//..................................................
			dwIdxOffset2 = li.HighPart;
			dwBytesRead = ReadIndex2();
			if (dwBytesRead == -1)
			{
				goto EncipherEnd;
			}
			dwBytesRead = ReadRecord2();
			if (dwBytesRead == -1)
			{
				goto EncipherEnd;
			}
			// The public key is in lpKeyBuffer2.
			//...................................
			lpKeyBufferDup2 = lpKeyBuffer2;

			__asm
			{
				mov		edi,lpKeyBufferDup2
				mov		cl,byte ptr [edi]
				mov		dwCtb_Byte,ecx
			}
			GetPcktLength(lpKeyBufferDup2,dwCtb_Byte);

			__asm
			{
				mov		edi,lpKeyBufferDup2
				add		edi,CTB_SIZE
				add		edi,edx
				add		edi,eax
				mov		cl,byte ptr [edi]
				mov		dwCtb_Byte,ecx
				mov		lpKeyBufferDup2,edi
			}
			GetPcktLength(lpKeyBufferDup2,dwCtb_Byte);

			__asm
			{
				mov		edi,lpKeyBufferDup2
				add		edi,CTB_SIZE
				add		edi,edx
				mov		lpKeyBufferDup2,edi
			}
			// If the key is disabled, move Yes to the disabled field.
			//........................................................
			if (*lpKeyBufferDup2 & DISABLED_BIT)
			{
				CopyMemory(lpScratchCentralDir->DISABLED,&szYes,lstrlen(&szYes));
			}
		}
		__asm
		{
			mov		eax,dwCDStructLength
			add		lpScratchCentralDir,eax
		}
		dwSecretElements--;
	}
	// Setup the secret key to use group 2 and the public key for 1.
	//..............................................................
	SetUpGroup(PUBLIC_KEY,INDEX_UID,GROUP_ONE);
	SetUpGroup(SECRET_KEY,INDEX_UID,GROUP_TWO);

	// Flush and rewind all the files.
	//................................
	bResult = FlushAllFiles();
	if (!bResult)
	{
		goto EncipherEnd;
	}
	bResult = RewindAllKeyRingFiles();
	if (!bResult)
	{
		goto EncipherEnd;
	}
	// Mark the recipients for the encrypted file.
	//............................................
	bSingleSelectionOnly = FALSE;
	iItemsSelected = 0;
	lpScratchCentralDir = lpPublicKeyCentralDir;
	MarkType = MARK_KEYS;
	iMaxItems = dwPublicIds;
	iItemCount = dwPublicIds;

	// If we are encrypting an e-mail message change the header for
	// selecting keys for the recipients.
	//.............................................................
	if (bEncryptingEmail)
	{
		dwEditFunction = 19;
	}
	else
	{
		dwEditFunction = 12;
	}
	bResult = MarkTheKeys();
	if (!bResult || iItemsSelected == 0)
	{
		if (iItemsSelected == 0)
		{
			bCanceledMsgEncryption = TRUE;
		}
		goto EncipherEnd;
	}
	// Check out the recipients to make sure we do not have any
	// disabled keys.
	//.........................................................
	iRecipients = iItemsSelected;
	dwSmallestKey = -1;
	lpScratchCentralDir1 = lpPublicKeyCentralDir;
	while(iItemsSelected != 0)
	{
		while(TRUE)
		{
			if (lpScratchCentralDir1->STATE)
			{
				break;
			}
			__asm
			{
				mov		eax,dwCDLength
				add		lpScratchCentralDir1,eax
			}
		}
		CopyMemory(&CDLine,lpScratchCentralDir1,dwCDLength);
		ZeroMemory(&UserId,sizeof(UserId));
		CopyMemory(&UserId,&CDLine.ID,lstrlen((LPCTSTR)&CDLine.ID));
		dwIdxOffset1 = CDLine.IDX_OFFS;
		dwBytesRead = ReadIndex1();
		if (dwBytesRead == -1)
		{
			goto EncipherEnd;
		}
		dwBytesRead = ReadRecord1();
		if (dwBytesRead == -1)
		{
			goto EncipherEnd;
		}
		bKeyDisabled = FALSE;

		// Check out the key to make sure it is not disabled.
		//...................................................
		lpKeyBufferDup1 = lpKeyBuffer1;

		__asm
		{
			mov		edi,lpKeyBufferDup1
			mov		cl,byte ptr [edi]
			mov		dwCtb_Byte,ecx
		}
		GetPcktLength(lpKeyBufferDup1,dwCtb_Byte);

		__asm
		{
			mov		edi,lpKeyBufferDup1
			add		edi,CTB_SIZE
			add		edi,edx
			mov		lpTempEDI,edi
			add		edi,eax
			mov		cl,byte ptr [edi]
			mov		dwCtb_Byte,ecx
			mov		lpKeyBufferDup1,edi
		}
		GetPcktLength(lpKeyBufferDup1,dwCtb_Byte);

		__asm
		{
			mov		edi,lpKeyBufferDup1
			add		edi,CTB_SIZE
			add		edi,edx
			mov		lpKeyBufferDup1,edi
		}
		// If the key is disabled, unmark it.
		//...................................
		if (*lpKeyBufferDup1 & DISABLED_BIT)
		{
			lpScratchCentralDir1->STATE = 0;
			iRecipients--;
			bKeyDisabled = TRUE;
		}
		else
		{
			liRecipientsTimestamp.QuadPart = 0;

			// See if the validity period has expired.
			// If it has, unmark it.
			//........................................
			__asm
			{
				mov		edi,lpTempEDI
				add		edi,VERSION_SIZE
				mov		eax,dword ptr [edi]
				bswap	eax
				mov		liRecipientsTimestamp.LowPart,eax

				// Get the high 7 bits of the timestamp.
				//......................................
				mov		eax,dword ptr [edi+6]
				and		eax,0x00ff
				shr		eax,1
				mov		liRecipientsTimestamp.HighPart,eax

				add		edi,TIMESTAMP_SIZE
				movzx	eax,word ptr [edi]
				xchg	ah,al
				mov		dwTempEAX,eax
			}
			// If we have a validity period.
			//..............................
			if (dwTempEAX)
			{
				__asm
				{
					xor		edx,edx
					mov		eax,dwTempEAX
					mov		ecx,SECS_PER_DAY
					mul		ecx
					add		liRecipientsTimestamp.LowPart,eax
					adc		liRecipientsTimestamp.HighPart,edx
				}
				// Get the current timestamp and compare.
				//.......................................
				liCurrentTimestamp.QuadPart = GetTimestamp(TRUE);
				if (liRecipientsTimestamp.QuadPart  < liCurrentTimestamp.QuadPart )
				{
					lpScratchCentralDir1->STATE = 0;
					iRecipients--;
					bKeyDisabled = TRUE;
				}
			}
		}
		// Find the user id so we can retrieve the keylegit byte.
		//.......................................................
		lpKeyBufferDup1 = lpKeyBuffer1;
		while(TRUE)
		{
			__asm
			{
				mov		edi,lpKeyBufferDup1
				mov		al,byte ptr [edi]
				mov		cl,al
				mov		dwCtb_Byte,ecx
				and		al,CTB_MASK
				mov		TempCTB,al
			}
			if (TempCTB != CTB_USER_ID)
			{
				GetPcktLength(lpKeyBufferDup1,dwCtb_Byte);

				__asm
				{
					mov		edi,lpKeyBufferDup1
					add		edi,CTB_SIZE
					add		edi,edx
					add		edi,eax
					mov		lpKeyBufferDup1,edi
				}
			}
			else
			{
				GetPcktLength(lpKeyBufferDup1,dwCtb_Byte);

				__asm
				{
					mov		edi,lpKeyBufferDup1
					add		edi,CTB_SIZE
					add		edi,edx
					mov		dwUserIdLength,eax
					mov		lpUserId,edi
					add		edi,eax
					mov		lpKeyBufferDup1,edi	// Points to next packet.
				}
				iCompareResult = CompareString(LOCALE_USER_DEFAULT,0,(LPCTSTR)lpUserId,
											  dwUserIdLength,(LPCTSTR)&CDLine.ID,-1);
				if (iCompareResult == CSTR_EQUAL)
				{
					break;
				}
			}
		}
		// Now get the keylegit trust byte for this user id.
		//..................................................
		__asm
		{
			mov		edi,lpKeyBufferDup1
			mov		cl,byte ptr [edi]
			mov		dwCtb_Byte,ecx
		}
		GetPcktLength(lpKeyBufferDup1,dwCtb_Byte);

		__asm
		{
			mov		edi,lpKeyBufferDup1
			add		edi,CTB_SIZE
			add		edi,edx
			mov		al,byte ptr [edi]
			and		al,KEYLEGIT_MASK
			mov		KeyLegit,al
		}
		// If the key is disabled, say so.
		//................................
		if (bKeyDisabled)
		{
			LoadString(hInst,IDS_ENCDISABLED,(LPTSTR)&szFormatBuffer,sizeof(szFormatBuffer));
			StringCbPrintf((LPTSTR)&szOutBuffer,sizeof(szOutBuffer),(LPCTSTR)&szFormatBuffer,
							CDLine.ID);
			MessageBoxProc(hMainWindow,IDS_ENCIPHERFILE,(UINT)szOutBuffer,
						   MB_ICONHAND | MB_OK | MB_HELP,MB_ICONHAND,0);
		}
		// If the key is not disabled and not fully certified, ask
		// if we really want to use it.
		//........................................................
		if (KeyLegit < UID_COMPL_TRUST && !bKeyDisabled)
		{
			LoadString(hInst,IDS_ENCASKTOUSE,(LPTSTR)&szFormatBuffer,sizeof(szFormatBuffer));
			if (KeyLegit == UID_NOT_TRUST)
			{
				lpKeyLegit = &Key31;
			}
			else if (KeyLegit == UID_MARG_TRUST)
			{
				lpKeyLegit = &Key32;
			}
			else
			{
				lpKeyLegit = &Key58;
			}
			StringCbPrintf((LPTSTR)&szOutBuffer,sizeof(szOutBuffer),(LPCTSTR)&szFormatBuffer,
							CDLine.ID,lpKeyLegit);
			iResult = MessageBoxProc(hMainWindow,IDS_ENCIPHERFILE,(UINT)szOutBuffer,
									 MB_YESNOCANCEL | MB_HELP | MB_ICONQUESTION,
									 MB_ICONQUESTION,0);
			if (iResult == IDCANCEL)
			{
				goto EncipherEnd;
			}
			if (iResult == IDNO)
			{
				lpScratchCentralDir1->STATE = 0;
				iRecipients--;
			}
		}
		// If we are going to use this key, get the number of bits
		// in modulus n. If it is smaller than smallest key, put
		// the new value in smallest key. Also get the user id in
		// case there is only one recipient.
		//.........................................................
		if (lpScratchCentralDir1->STATE)
		{
			if (lpScratchCentralDir1->NUMBER_OF_BITS < dwSmallestKey)
			{
				dwSmallestKey = lpScratchCentralDir1->NUMBER_OF_BITS;
			}
			ZeroMemory(&szRecipient,sizeof(szRecipient));
			CopyMemory(&szRecipient,lpScratchCentralDir1->ID,sizeof(CDLine.ID));
		}
		// Process the next selection.
		//............................
		__asm
		{
			mov		eax,dwCDStructLength
			add		lpScratchCentralDir1,eax
		}
		iItemsSelected--;
	}
	// If there are no more recipients left, say so and exit.
	//.......................................................
	if (!iRecipients)
	{
		SetLastError(IDS_NORECIPIENTS);
		ErrorProcedure((LPTSTR)&szFileToEncipher,IDS_ENCRYPT,MB_OK);
		bCanceledMsgEncryption = TRUE;
		goto EncipherEnd;
	}
	// If we have more than 1 rcipient, or only 1 recipient and the
	// smallest key is less than 2,200 bits, we use a random session
	// key.
	//.............................................................
	if (iRecipients > 1 || dwSmallestKey < 2200)
	{
		dwUseSessionKey = USE_RANDOM;
	}
	else
	{
		// Only one recipient. Ask if we want to use a session key
		// or an otp key file or a pad file.
		//........................................................
		iResult = DialogBox(hInst,TEXT("ASKSESSIONKEY"),hMainWindow,
						   (DLGPROC)AskSessionKeyProc);

		// See if we had a system error in creating the dialog box.
		//.........................................................
		if (iResult == -1)
		{
			ErrorProcedure(lpszNA,IDS_CREATEDIALOGBOX,MB_OK);
			goto EncipherEnd;
		}
		// Destroy the icon if we used it.
		//................................
		if (hIcon)
		{
			DestroyIcon(hIcon);
			hIcon = 0;
		}
		// Quit if we canceled.
		//.....................
		if (iResult == IDCANCEL)
		{
			bCanceledMsgEncryption = TRUE;
			goto EncipherEnd;
		}
	}
	// Select the true one time pad or the otp key file to use to encipher the file 
	// with. Set RingMask to use all 256 random number generators for the OTP Key File.
	//.................................................................................
	if (dwUseSessionKey != USE_RANDOM)
	{
		RingMask = -1;
		
		while(TRUE)
		{
			// Select a valid true one time pad or otp key file.
			//..................................................
			while(TRUE)
			{
				ZeroMemory(&szOtpKeyFile,sizeof(szOtpKeyFile));

				// Initialize the OPENFILENAME structure.
				//.......................................
				if (dwUseSessionKey == USE_KEY)
				{
					InitializeOFN(&ofn,SAVE_OTPKEYFILES);
				}
				else
				{
					InitializeOFN(&ofn,SAVE_TOTPFILES);
				}
				// Initialize with specific information for this procedure.
				//.........................................................
				ofn.lpstrFile = szOtpKeyFile;
				ofn.nMaxFile = sizeof(szOtpKeyFile);
				ofn.hwndOwner = hMainWindow;
				ofn.hInstance = hInst;
				ofn.nFilterIndex = 1;
				ofn.Flags = (OFN_EXPLORER | OFN_FILEMUSTEXIST | OFN_PATHMUSTEXIST |
							 OFN_ENABLEHOOK | OFN_ENABLESIZING | OFN_HIDEREADONLY |
							 OFN_SHOWHELP);
				if (!cfg.dwWipeAfterUse)
				{
					ofn.Flags |= OFN_ENABLETEMPLATE;	
				}
				ofn.lpstrDefExt = NULL;

				if (dwUseSessionKey == USE_KEY)
				{
					ofn.lpstrFilter = TEXT("One Time Pad Key Files [.otp]\0*.otp\0All Files [*.*]\0*.*\0");
					ofn.lpstrTitle = TEXT("Select an OTP Key File to Encipher Your File With");
					if (!cfg.dwWipeAfterUse)
					{
						if (bWin2000OrGreater)
						{
							ofn.lpTemplateName = TEXT("WIPEOTPKEYFILENEW");
						}
						else
						{
							ofn.lpTemplateName = TEXT("WIPEOTPKEYFILE");
						}
						ofn.lpfnHook = MyOTPOFNHookProc;
					}
					else
					{
						ofn.lpfnHook = MyOFNHookProc;
					}
				}
				else
				{
					ofn.lpstrFilter = TEXT("True One Time Pad Files [.pad]\0*.pad\0All Files [*.*]\0*.*\0");
					ofn.lpstrTitle = TEXT("Select a True One Time Pad File to Encipher Your File With");
					if (!cfg.dwWipeAfterUse)
					{
						if (bWin2000OrGreater)
						{
							ofn.lpTemplateName = TEXT("WIPETRUEOTPFILENEW");
						}
						else
						{
							ofn.lpTemplateName = TEXT("WIPETRUEOTPFILE");
						}
						ofn.lpfnHook = MyTrueOFNHookProc;
					}
					else
					{
						ofn.lpfnHook = MyOFNHookProc;
					}
				}
				// Setup the icon to use in the caption bar.
				//..........................................
				lpIconPointer = lpszAppName;

				if (!GetOpenFileName(&ofn))
				{
					CommDlgBoxErrorProc(IDS_GET_FILES);
					goto EncipherEnd;
				}
				bCanceledMsgEncryption = FALSE;

				if (dwUseSessionKey == USE_KEY)
				{
					SaveDirName((LPBYTE)&szOtpKeyFile,SAVE_OTPKEYFILES,TRUE);
				}
				else
				{
					SaveDirName((LPBYTE)&szOtpKeyFile,SAVE_TOTPFILES,TRUE);
				}
				// Check to make sure it is a valid otp key file.
				//...............................................
				if (dwUseSessionKey == USE_KEY)
				{
					hOtpKeyFile = IsValidOTPKeyFile((LPTSTR)&szOtpKeyFile);
					if (hOtpKeyFile)
					{
						break;
					}
				}
				else
				{
					hOtpKeyFile = IsValidTruePadFile((LPTSTR)&szOtpKeyFile);
					if (hOtpKeyFile)
					{
						break;
					}
				}
			}
			// Reset the destination dir name.
			//................................
			SaveDirName((LPBYTE)&szDestination,SAVE_DESTINATION,TRUE);

			// Setup the file name in the correct non reproducible header.
			//............................................................
			lpOtpFileName = PathFindFileName((LPCTSTR)&szOtpKeyFile);
			if (dwUseSessionKey == USE_KEY)
			{
				CopyMemory(&nrphdr.LONG_FILE_NAME,lpOtpFileName,
						   lstrlen((LPCTSTR)lpOtpFileName));
			}
			else
			{
				CopyMemory(&nrppadhdr.LONG_FILE_NAME,lpOtpFileName,
						   lstrlen((LPCTSTR)lpOtpFileName));
			}
			// If we are using a pad file get the starting point and place it in
			// the header, and set the file pointer to the starting point.
			//..................................................................
			if (dwUseSessionKey == USE_PAD)
			{
				// Get the size of the pad file.
				//..............................
				liPadFreeBytes.QuadPart = GetMyFileSize((LPTSTR)&szOtpKeyFile,hOtpKeyFile);
				if (liPadFreeBytes.QuadPart == -1)
				{
					goto EncipherEnd;
				}
				// Adjust the free random bytes to account for the fip header that is
				// encrypted.
				//...................................................................
				liPadFreeBytes.QuadPart -= (sizeof(fip)-3);

				li.QuadPart = PAD_ID_SIZE;
				li.QuadPart = SetMyFilePointer((LPTSTR)&szOtpKeyFile,hOtpKeyFile,li.QuadPart,
											    FILE_BEGIN);
				if (li.QuadPart == -1)
				{
					goto EncipherEnd;
				}
				bResult = ReadMyFile((LPTSTR)&szOtpKeyFile,hOtpKeyFile,
									  &nrppadhdr.ULI_STARTING_POINT.QuadPart,
									  sizeof(LARGE_INTEGER),&dwBytesRead,NULL);
				if (!bResult)
				{
					goto EncipherEnd;
				}
				li.QuadPart = SetMyFilePointer((LPTSTR)&szOtpKeyFile,hOtpKeyFile,
											    nrppadhdr.ULI_STARTING_POINT.QuadPart,
											    FILE_BEGIN);
				if (li.QuadPart == -1)
				{
					goto EncipherEnd;
				}
				// Check to make sure we have enough random bytes in the pad file to
				// encipher our file with.
				//..................................................................
				liPadFreeBytes.QuadPart -= li.QuadPart;
				if (liPadFreeBytes.QuadPart < liEncFileSize.QuadPart)
				{
					SetLastError(IDS_PADBYTESNOTENOUGH);
					ErrorProcedure((LPTSTR)&szOtpKeyFile,IDS_GETFILESIZE,MB_OK);
					CloseMyHandle((LPTSTR)&szOtpKeyFile,hOtpKeyFile);
					hOtpKeyFile = 0;
					continue;
				}
				// Setup for wiping the section of the true one time pad file we used.
				//....................................................................
				liStartPosition.QuadPart = nrppadhdr.ULI_STARTING_POINT.QuadPart;
				liWipeLength.QuadPart = (liEncFileSize.QuadPart + (sizeof(FILE_INFO_PCKT)-3));
			}
			break;
		}	// Second while(TRUE)	
	}
	// Set the public key to use key id in group one.
	//...............................................
	SetUpGroup(PUBLIC_KEY,INDEX_KEY,GROUP_ONE);
		
	// Select the secret key to sign the file with.
	//.............................................
	bSingleSelectionOnly = TRUE;
	iItemsSelected = 0;
	lpScratchCentralDir = lpSecretKeyCentralDir;
	MarkType = MARK_KEYS;
	iMaxItems = dwSecretIds;
	iItemCount = dwSecretIds;
	dwEditFunction = 11;
	bResult = MarkTheKeys();
	if (!bResult || iItemsSelected == 0)
	{
		if (iItemsSelected == 0)
		{
			bCanceledMsgEncryption = TRUE;
		}
		goto EncipherEnd;
	}
	// Find our selected secret key so we can determine if it is
	// disabled or not.
	//..........................................................
	lpScratchCentralDir = lpSecretKeyCentralDir;
	while(TRUE)
	{
		if (lpScratchCentralDir->STATE)
		{
			break;
		}
		__asm
		{
			mov		eax,dwCDStructLength
			add		lpScratchCentralDir,eax
		}
	}
	CopyMemory(&CDLine1,lpScratchCentralDir,sizeof(CD_STRUCT));
	CopyMemory(&KeySID,&CDLine1.KEY_SIG_ID,KEY_ID_SIZE);
	CopyMemory(&skh.KEY_ID,&CDLine1.KEY_SIG_ID,KEY_ID_SIZE);

	// Search for the corresponding public key so we can check
	// if the secret key is disabled.
	//........................................................
	li.QuadPart = SearchMyFileBinary(lpIndexFile1,&KeySID,KEY_ID_SIZE,hIdxHandle1,0,
									 &KeyIdSearch);
	if (li.QuadPart == -1 || li.QuadPart == 0)
	{
		SetLastError(IDS_CANNOTDETERMINEIFSECRETKEYDISABLED);
		ErrorProcedure(lpRingFile2,IDS_READ,MB_OK);
		goto EncipherEnd;
	}
	// We had a match. See if the public/secret key pair
	// is disabled.
	//..................................................
	dwIdxOffset1 = li.HighPart;
	dwBytesRead = ReadIndex1();
	if (dwBytesRead == -1)
	{
		goto EncipherEnd;
	}
	dwBytesRead = ReadRecord1();
	if (dwBytesRead == -1)
	{
		goto EncipherEnd;
	}
	bKeyDisabled = FALSE;

	// The public key is in lpKeyBuffer1.
	//...................................
	lpKeyBufferDup1 = lpKeyBuffer1;

	__asm
	{
		mov		edi,lpKeyBufferDup1
		mov		cl,byte ptr [edi]
		mov		dwCtb_Byte,ecx
	}
	GetPcktLength(lpKeyBufferDup1,dwCtb_Byte);

	__asm
	{
		mov		edi,lpKeyBufferDup1
		add		edi,CTB_SIZE
		add		edi,edx
		mov		lpTempEDI,edi
		add		edi,eax
		mov		cl,byte ptr [edi]
		mov		dwCtb_Byte,ecx
		mov		lpKeyBufferDup1,edi
	}
	GetPcktLength(lpKeyBufferDup1,dwCtb_Byte);

	__asm
	{
		mov		edi,lpKeyBufferDup1
		add		edi,CTB_SIZE
		add		edi,edx
		mov		lpKeyBufferDup1,edi
	}
	// If the key is disabled, unmark it.
	//...................................
	if (*lpKeyBufferDup1 & DISABLED_BIT)
	{
		lpScratchCentralDir->STATE = 0;
		bKeyDisabled = TRUE;
	}
	else
	{
		// Use liRecipientsTimestamp to do our validity period
		// calculations.
		//....................................................
		liRecipientsTimestamp.QuadPart = 0;

		// See if the validity period has expired.
		// If it has, unmark it.
		//........................................
		__asm
		{
			mov		edi,lpTempEDI
			add		edi,VERSION_SIZE
			mov		eax,dword ptr [edi]
			bswap	eax
			mov		liRecipientsTimestamp.LowPart,eax

			// Get the high order 7 bits of the timestamp.
			//............................................
			mov		eax,dword ptr [edi+6]
			and		eax,0x00ff
			shr		eax,1
			mov		liRecipientsTimestamp.HighPart,eax

			add		edi,TIMESTAMP_SIZE
			movzx	eax,word ptr [edi]
			xchg	ah,al
			mov		dwTempEAX,eax
		}
		// If we have a validity period.
		//..............................
		if (dwTempEAX)
		{
			__asm
			{
				xor		edx,edx
				mov		eax,dwTempEAX
				mov		ecx,SECS_PER_DAY
				mul		ecx
				add		liRecipientsTimestamp.LowPart,eax
				adc		liRecipientsTimestamp.HighPart,edx
			}
			// Get the current timestamp and compare.
			//.......................................
			liCurrentTimestamp.QuadPart = GetTimestamp(TRUE);
			if (liRecipientsTimestamp.QuadPart  < liCurrentTimestamp.QuadPart)
			{
				lpScratchCentralDir->STATE = 0;
				bKeyDisabled = TRUE;
			}
		}
	}
	if (bKeyDisabled)
	{
		SetLastError(IDS_SELECTEDSECRETKEYISDISABLED);
		ErrorProcedure(lpRingFile2,IDS_READ,MB_OK);
		bCanceledMsgEncryption = TRUE;
		goto EncipherEnd;
	}
	// Make sure we know the pass phrase to the secret key.
	// Put the secret key in lpKeyBuffer2.
	//.....................................................
	dwIdxOffset2 = CDLine1.IDX_OFFS;
	dwBytesRead = ReadIndex2();
	if (dwBytesRead == -1)
	{
		goto EncipherEnd;
	}
	dwBytesRead = ReadRecord2();
	if (dwBytesRead == -1)
	{
		goto EncipherEnd;
	}
	CopyMemory(&TempUserId,CDLine1.ID,sizeof(TempUserId));
	iResult = SignSetup(lpKeyBuffer2,IDS_NOENCRYPTION,IDS_NOENCRYPTPP);
	if (!iResult)
	{
		bCanceledMsgEncryption = TRUE;
		goto EncipherEnd;
	}
	dwEncModNBytes = dwN_Bytes;

	// Setup the type of message digest algorithm to use in the signature.
	//....................................................................
	if (bUseMd5)
	{
		skh.APPEND_LENGTH = SKE_APPEND_LGTH;
		skh.MD5_ALGOR = MD5_ALGORITHM;
	}
	else
	{
		skh.APPEND_LENGTH = SKE_SHA_APPEND_LGTH;

		if (dwN_Bytes > SHA512_MIN_KEY_SIZE)
		{
			skh.MD5_ALGOR = SHA512_ALGORITHM;
		}
		else
		{	
			skh.MD5_ALGOR = SHA_ALGORITHM;
		}
	}
	// Reset the public key back to using user ids.
	//.............................................
	SetUpGroup(PUBLIC_KEY,INDEX_UID,GROUP_ONE);

	// Set default text color of black.
	//.................................
	crClassification = RGB(0,0,0);

	// Get any special instructions to send to the recipients.
	//........................................................
	iResult = DialogBox(hInst,TEXT("GETSPECIALINSTRUCTIONS"),
						hMainWindow,(DLGPROC)GetSpecialInstructionsProc);

	// See if we had a system error in creating the dialog box.
	//.........................................................
	if (iResult == -1)
	{
		ErrorProcedure(lpszNA,IDS_CREATEDIALOGBOX,MB_OK);
		goto EncipherEnd;
	}
	// Destroy the icon if we used it.
	//................................
	if (hIcon)
	{
		DestroyIcon(hIcon);
		hIcon = 0;
	}
	// Quit if we canceled.
	//.....................
	if (iResult == IDCANCEL)
	{
		bCanceledMsgEncryption = TRUE;
		goto EncipherEnd;
	}
	// Setup our elapsed timer.
	//.........................
	dwElapHours = 0;
	dwElapMinutes = 0;
	dwElapSeconds = 0;
	uTimer = SetTimer(hMainWindow,MY_TIMER,1000,(TIMERPROC)My1SecondTimer);

	DisplayZeroTimer();

	EmptyTheMessageQue();

	// We have to mark the Universal Public Key if it is required.
	//............................................................
	if (bAa)
	{
		lpScratchCentralDir = lpPublicKeyCentralDir;

		while(TRUE)
		{
			iCompareResult = CompareString(LOCALE_USER_DEFAULT,0,(LPCTSTR)&cfg.V1.V2,
										   KEY_ID_SIZE,
										   (LPCTSTR)lpScratchCentralDir->KEY_SIG_ID,
										   KEY_ID_SIZE);
			if (iCompareResult == CSTR_EQUAL)
			{
				// If it is already selected, we do not need to mark it.
				//......................................................
				if (lpScratchCentralDir->STATE == 0)
				{
					lpScratchCentralDir->STATE = LVIS_SELECTED;

					// Adjust the smallest key if required.
					//.....................................
					if (lpScratchCentralDir->NUMBER_OF_BITS < dwSmallestKey)
					{
						dwSmallestKey = lpScratchCentralDir->NUMBER_OF_BITS;
					}
					iRecipients++;
				}
				break;
			}
			__asm
			{
				mov		eax,dwCDLength
				add		lpScratchCentralDir,eax
			}
		}
	}
	// If we are going to use a random session key set it up.
	// First we have to set some values based on the smallest
	// key used.
	//.......................................................
	if (dwUseSessionKey == USE_RANDOM)
	{
		lpCsumOffset = (LPBYTE)&rphdr;
		lpSeedOffset = (LPBYTE)&rphdr;

		// Initial settings.
		//..................
		dwRngsUsed = RNGS_128;
		dwReproLength = KEY_128_LGTH;

		if (dwSmallestKey < KEY_BITS_8)
		{
			dwRngsUsed = RNGS_4;
			dwReproLength = KEY_4_LGTH;
		}
		else if (dwSmallestKey < KEY_BITS_16)
		{
			dwRngsUsed = RNGS_8;
			dwReproLength = KEY_8_LGTH;
		}
		else if (dwSmallestKey < KEY_BITS_32)
		{
			dwRngsUsed = RNGS_16;
			dwReproLength = KEY_16_LGTH;
		}
		else if (dwSmallestKey < KEY_BITS_64)
		{
			dwRngsUsed = RNGS_32;
			dwReproLength = KEY_32_LGTH;
		}
		else if (dwSmallestKey < KEY_BITS_128)
		{
			dwRngsUsed = RNGS_64;
			dwReproLength = KEY_64_LGTH;
		}
		lpCsumOffset += (dwReproLength - SIZE_OF_CSUM);
		lpSeedOffset += (dwReproLength - SIZE_OF_CSUM - SIZE_OF_SEED);

		__asm
		{
			mov		eax,dwRngsUsed
			mov		RingMask,al
			dec		RingMask
			mov		ecx,SEEDS_IN_RNG
			mul		ecx
			mov		dwSeedsNeeded,eax
		}
		dwSeedsNeededDup = dwSeedsNeeded;
		lpTempHeader = (LPBYTE)&rphdr;
		StirTheBits();

		// Fill up the header with our randomly generated numbers.
		//........................................................
		while(dwSeedsNeededDup > 0)
		{
			while(TRUE)
			{
				GetRandomBits(32,&Seed);
				if (Seed >= 100000001)
				{
					break;
				}
			}
			__asm
			{
				mov		edi,lpTempHeader
				mov		eax,Seed
				stosd
				mov		lpTempHeader,edi
			}
			dwSeedsNeededDup--;
		}
		// Get a 5 bit random array shift factor between 17 and 24.
		//.........................................................
		while(TRUE)
		{
			GetRandomBits(5,&Seed);
			if (Seed >= 17 && Seed <= 24)
			{
				break;
			}
		}
		// Shift the random numbers in the factor array.
		//..............................................
		__asm
		{
			xor		ebx,ebx
			xor		edi,edi
			mov		ecx,dwRngsUsed
		L1:	push	ecx
			mov		ecx,Seed
			mov		eax,dword ptr rphdr[edi*4]
			shrd	eax,ebx,cl
			mov		dword ptr rphdr[edi*4],eax
			inc		edi
			pop		ecx
			dec		ecx
			jnz		L1
		}
	}
	// Get a random initial seed for the random number generators.
	//............................................................
	while(TRUE)
	{
		GetRandomBits(32,&nrphdr.INITIAL_SEED);
		if (nrphdr.INITIAL_SEED >= 100000001)
		{
			break;
		}
	}
	// If we are using a session key, set up its initial seed.
	//........................................................
	if (dwUseSessionKey == USE_RANDOM)
	{
		__asm
		{
			mov		eax,nrphdr.INITIAL_SEED
			mov		edi,lpSeedOffset
			mov		dword ptr [edi],eax
		}
	}
	Seed = nrphdr.INITIAL_SEED;
	StirTheBits();

	// Setup the public key encrypted conventional key packet.
	// Our checksum is stored MSB to LSB. Make sure decipher
	// procedure knows about the change.
	//........................................................
	if (dwUseSessionKey == USE_RANDOM)
	{
		dwCheckSum = CheckSum((LPBYTE)&rphdr,(dwReproLength - SIZE_OF_CSUM));

		__asm
		{
			mov		edi,lpCsumOffset
			mov		eax,dwCheckSum
			xchg	ah,al
			mov		word ptr [edi],ax
		}
	}
	else if (dwUseSessionKey == USE_KEY)
	{
		dwCheckSum = CheckSum((LPBYTE)&nrphdr,sizeof(nrphdr) - 2);

		__asm
		{
			mov		eax,dwCheckSum
			xchg	ah,al
			mov		dwCheckSum,eax
		}
		nrphdr.CHECKSUM = LOWORD(dwCheckSum);
	}
	else
	{
		dwCheckSum = CheckSum((LPBYTE)&nrppadhdr,sizeof(nrppadhdr) - 2);

		__asm
		{
			mov		eax,dwCheckSum
			xchg	ah,al
			mov		dwCheckSum,eax
		}
		nrppadhdr.CHECKSUM = LOWORD(dwCheckSum);
	}
	// Create the output file.
	//........................
	hEncryptedFile = CreateMyFile((LPTSTR)&szDestination,GENERIC_READ | GENERIC_WRITE,0,
							       NULL,CREATE_NEW,FILE_ATTRIBUTE_NORMAL,NULL);
	if (!hEncryptedFile)
	{
		goto EncipherEnd;
	}
	// Setup a hook procedure to trap the tab key and mouse input.
	//............................................................
	hHook = SetWindowsHookEx(WH_KEYBOARD,(HOOKPROC)TrapTabKey,NULL,0);
	hMouseHook = SetWindowsHookEx(WH_MOUSE,(HOOKPROC)TrapMouseInput,NULL,0);

	// Disply the progress information screen.
	//........................................
	bCancelOperation = FALSE;
	hDialogModeLess = CreateDialog(hInst,TEXT("ENCRYPTAFILE"),hMainWindow,
								  (DLGPROC)EncryptAFileProc);
	if (!hDialogModeLess)
	{
		ErrorProcedure(lpszNA,IDS_CREATEDIALOGBOX,MB_OK);
		goto EncipherEnd;
	}
	// Enable the encrypting and writing recipients pke packets.
	//..........................................................
	EnableWindow(GetDlgItem(hDialogModeLess,IDC_ENCRYPT1),TRUE);

	// Calculate and write the public key encrypted packet for each
	// recipient.
	//.............................................................
	lpScratchCentralDir = lpPublicKeyCentralDir;
	while(iRecipients > 0)
	{
		while(TRUE)
		{
			if (lpScratchCentralDir->STATE)
			{
				break;
			}
			__asm
			{
				mov		eax,dwCDLength
				add		lpScratchCentralDir,eax
			}
		}
		// We have a marked key. Unmark it.
		//.................................
		lpScratchCentralDir->STATE = 0;

		// Store the key id in the pke header.
		//....................................
		CopyMemory(&pkh.KEY_ID,lpScratchCentralDir->KEY_SIG_ID,sizeof(pkh.KEY_ID));

		// Get the public key.
		//....................
		dwIdxOffset1 = lpScratchCentralDir->IDX_OFFS;
		dwBytesRead = ReadIndex1();
		if (dwBytesRead == -1)
		{
			goto EncipherEnd;
		}
		dwBytesRead = ReadRecord1();
		if (dwBytesRead == -1)
		{
			goto EncipherEnd;
		}
		// Clear Modulus n and Exponent e.
		//................................
		Mod_N_Mpi = 0;
		E_Mpi = 0;
		ZeroMemory(&Modulus_N,MAX_MOD_SLOP);
		ZeroMemory(&E_Temp,MAX_MOD_SLOP);

		// Extract Modulus n and Exponent e for the public key
		// encryption procedure.
		//....................................................
		lpKeyBufferDup1 = lpKeyBuffer1;

		__asm
		{
			mov		edi,lpKeyBufferDup1
			mov		cl,byte ptr [edi]
			mov		dwCtb_Byte,ecx
		}
		GetPcktLength(lpKeyBufferDup1,dwCtb_Byte);

		__asm
		{
			mov		edi,lpKeyBufferDup1
			add		edi,CTB_SIZE
			add		edi,edx
			add		edi,(VERSION_SIZE+TIMESTAMP_SIZE+VALIDITY_SIZE+ALGORITHM_SIZE)
			movzx	eax,word ptr [edi]
			add		edi,MPI_PREFIX_SIZE
			xchg	ah,al
			add		eax,7
			shr		eax,3
			mov		dwN_Bytes,eax
			push	edi
			push	eax
			mov		esi,edi
			mov		ecx,eax
			mov		edi,offset Modulus_N
			rep		movsb
			pop		eax
			pop		edi
			add		edi,eax
			movzx	eax,word ptr [edi]
			add		edi,MPI_PREFIX_SIZE
			xchg	ah,al
			add		eax,7
			shr		eax,3
			mov		dwE_Bytes,eax
			mov		ecx,eax
			mov		esi,edi
			mov		edi,offset E_Temp
			rep		movsb
		}
		// Circle swap Modulus n and Exponent e.
		//......................................
		CircleSwap((LPBYTE)&E_Temp,dwE_Bytes);
		CircleSwap((LPBYTE)&Modulus_N,dwN_Bytes);

		EmptyTheMessageQue();
		if (bCancelOperation== TRUE)
		{
			goto EncipherEnd;
		}
		// Encrypt the public key encryption packet for this
		// recipient.
		//..................................................
		if (dwUseSessionKey == USE_RANDOM)
		{
			RsaPubEnc(&Temp1,(LPBYTE)&rphdr,dwReproLength,(LPBYTE)&E_Temp,
					 (LPBYTE)&Modulus_N,dwN_Bytes);
		}
		else if (dwUseSessionKey == USE_KEY)
		{
			RsaPubEnc(&Temp1,(LPBYTE)&nrphdr,sizeof(nrphdr),
				     (LPBYTE)&E_Temp,(LPBYTE)&Modulus_N,dwN_Bytes);
		}
		else
		{
			RsaPubEnc(&Temp1,(LPBYTE)&nrppadhdr,sizeof(nrppadhdr),
					 (LPBYTE)&E_Temp,(LPBYTE)&Modulus_N,dwN_Bytes);
		}
		EmptyTheMessageQue();
		if (bCancelOperation == TRUE)
		{
			goto EncipherEnd;
		}
		__asm
		{
			mov		eax,dwCountBits
			xchg	ah,al
			mov		pkh.MPI_PREFIX,ax
		}
		dwTempEAX = (dwCountBytes + sizeof(pkh) -3);

		__asm
		{
			mov		eax,dwTempEAX
			xchg	ah,al
			mov		pkh.LENGTH,ax
		}
		bResult = WriteMyFile((LPTSTR)&szDestination,hEncryptedFile,
							   &pkh,sizeof(pkh),&dwBytesWritten,NULL);
		if (!bResult)
		{
			goto EncipherEnd;
		}
		CircleSwap((LPBYTE)&Temp1,dwCountBytes);
		bResult = WriteMyFile((LPTSTR)&szDestination,hEncryptedFile,
							   &Temp1,dwCountBytes,&dwBytesWritten,NULL);
		if (!bResult)
		{
			goto EncipherEnd;
		}

		EmptyTheMessageQue();
		if (bCancelOperation == TRUE)
		{
			goto EncipherEnd;
		}
		// Go and do the next recipient if there is one.
		//..............................................
		__asm
		{
			mov		eax,dwCDStructLength
			add		lpScratchCentralDir,eax
		}
		iRecipients--;
	}
	// Calculate the files md5, Sha1, or Sha512 message digest.
	//.........................................................
	CheckDlgButton(hDialogModeLess,IDC_ENCRYPT1,BST_CHECKED);
	EnableWindow(GetDlgItem(hDialogModeLess,IDC_ENCRYPT2),TRUE);

	uliTemp.QuadPart = GetTimestamp(TRUE);

	if (bUseMd5)
	{
		__asm
		{
			mov		eax,uliTemp.LowPart
			bswap	eax
			mov		uliTemp.LowPart,eax
		}
		skh.TIMESTAMP = uliTemp.LowPart;
		bResult = FileMd5((LPBYTE)&szFileToEncipher,(LPBYTE)&Md5Digest,
						  (LPBYTE)&skh.CLASS,SKE_APPEND_LGTH);
		if (!bResult)
		{
			goto EncipherEnd;
		}
		skh.MD5_2_BYTES[0] = Md5Digest[0];
		skh.MD5_2_BYTES[1] = Md5Digest[1];
	}
	else
	{
		// Setup the timestamp for the Sha1 or Sha512 message digest.
		//...........................................................
		__asm
		{
			mov		eax,uliTemp.LowPart
			bswap	eax
			mov		uliTemp.LowPart,eax
		}
		skh.TIMESTAMP = uliTemp.LowPart;

		__asm
		{
			mov		al,skh.RSA_ALGOR
			mov		edx,uliTemp.HighPart
			and		edx,0x00ff
			shl		edx,1
			or		al,dl
			mov		skh.RSA_ALGOR,al
		}
		// Use the Sha1 message digest.
		//.............................
		if (skh.MD5_ALGOR == SHA_ENCRYPTED)
		{
			bResult = FileSha((LPBYTE)&szFileToEncipher,(LPBYTE)&ShaDigest,
							 (LPBYTE)&skh.CLASS,SKE_SHA_APPEND_LGTH);
			if (!bResult)
			{
				goto EncipherEnd;
			}
			skh.MD5_2_BYTES[0] = ShaDigest[0];
			skh.MD5_2_BYTES[1] = ShaDigest[1];
		}
		else
		{
			// Use the Sha512 message digest.
			//...............................
			bResult = FileSha512((LPBYTE)&szFileToEncipher,(LPBYTE)&Sha512Digest,
							 (LPBYTE)&skh.CLASS,SKE_SHA_APPEND_LGTH);
			if (!bResult)
			{
				goto EncipherEnd;
			}
			skh.MD5_2_BYTES[0] = Sha512Digest[0];
			skh.MD5_2_BYTES[1] = Sha512Digest[1];
		}
	}
	EmptyTheMessageQue();
	if (bCancelOperation == TRUE)
	{
		goto EncipherEnd;
	}
	// Calculate the signature packet.
	//........................................
	CheckDlgButton(hDialogModeLess,IDC_ENCRYPT2,BST_CHECKED);
	EnableWindow(GetDlgItem(hDialogModeLess,IDC_ENCRYPT3),TRUE);

	// Inform that signature calculations could take awhile.
	//......................................................
	LoadString(hInst,IDS_SIGSTAKEAWHILE,(LPTSTR)&szOutBuffer,sizeof(szOutBuffer));
	SetDlgItemText(hDialogModeLess,IDC_MESSAGE,(LPCTSTR)&szOutBuffer);

	if (bUseMd5)
	{
		RsaPriEnc((LPBYTE)&Temp1,(LPBYTE)&Md5Digest,MD5_DIGEST_SIZE,
				 (LPBYTE)&D_Temp,(LPBYTE)&Prime_P,(LPBYTE)&Prime_Q,
				 (LPBYTE)&U_Temp,dwEncModNBytes);
	}
	else
	{
		if (skh.MD5_ALGOR == SHA_ENCRYPTED)
		{
			RsaPriEnc((LPBYTE)&Temp1,(LPBYTE)&ShaDigest,SHA_DIGEST_SIZE,
					 (LPBYTE)&D_Temp,(LPBYTE)&Prime_P,(LPBYTE)&Prime_Q,
					 (LPBYTE)&U_Temp,dwEncModNBytes);
		}
		else
		{
			RsaPriEnc((LPBYTE)&Temp1,(LPBYTE)&Sha512Digest,SHA512_DIGEST_SIZE,
					 (LPBYTE)&D_Temp,(LPBYTE)&Prime_P,(LPBYTE)&Prime_Q,
					 (LPBYTE)&U_Temp,dwEncModNBytes);
		}
	}
	EmptyTheMessageQue();
	if (bCancelOperation == TRUE)
	{
		goto EncipherEnd;
	}
	// Setup the mpi bit count.
	//.........................
	__asm
	{
		mov		eax,dwCountBits
		xchg	ah,al
		mov		dwTempEAX,eax
	}
	skh.MPI_PREFIX = LOWORD(dwTempEAX);

	dwTempEAX = (dwCountBytes + sizeof(skh) - 3);

	__asm
	{
		mov		eax,dwTempEAX
		xchg	ah,al
		mov		dwTempEAX,eax
	}
	skh.LENGTH = LOWORD(dwTempEAX);

	// Write the header to disk.
	//..........................
	bResult = WriteMyFile((LPTSTR)&szDestination,hEncryptedFile,
						   &skh,sizeof(skh),&dwBytesWritten,NULL);
	if (!bResult)
	{
		goto EncipherEnd;
	}
	// Write the rsa encrypted integer to disk.
	//.........................................
	CircleSwap((LPBYTE)&Temp1,dwCountBytes);
	bResult = WriteMyFile((LPBYTE)&szDestination,hEncryptedFile,
						   &Temp1,dwCountBytes,&dwBytesWritten,NULL);
	if (!bResult)
	{
		goto EncipherEnd;
	}
	SetDlgItemText(hDialogModeLess,IDC_MESSAGE,(LPCTSTR)lpszNullString);

	// Encrypt and write the file info packet.
	//........................................
	CheckDlgButton(hDialogModeLess,IDC_ENCRYPT3,BST_CHECKED);
	EnableWindow(GetDlgItem(hDialogModeLess,IDC_ENCRYPT4),TRUE);

	// Setup the random number generators.
	//....................................
	if (dwUseSessionKey == USE_KEY)
	{
		bResult = ReadMyFile((LPTSTR)&szOtpKeyFile,hOtpKeyFile,
							  lpKeyBuffer3,(Goal*4),&dwBytesRead,NULL);
		if (!bResult)
		{
			goto EncipherEnd;
		}
		SetupArrays(lpKeyBuffer3);
	}
	else if (dwUseSessionKey == USE_RANDOM)
	{
		// Setup the factor array first, followed by the tops
		// and seeds array.
		//...................................................
		__asm
		{
			mov		eax,dwRngsUsed
			mov		ecx,SIZE_OF_SEED
			mul		ecx
			mov		ecx,eax
			push	ecx
			push	ecx
			mov		esi,offset rphdr
			mov		edi,offset FactorArray
			rep		movsb
			pop		ecx
			mov		edi,offset TopsArray
			rep		movsb
			pop		ecx
			mov		edi,offset SeedsArray
			rep		movsb

			// Setup the first LastSeed value.
			//................................
			mov		al,byte ptr rphdr[12]
			and		al,RingMask
			mov		LastSeed,al

			// Setup the DbleNumber value.
			//............................
			mov		esi,lpSeedOffset
			mov		eax,dword ptr [esi-7]
			clc
			rcl		eax,1
			jnc		L2
			mov		eax,-1
		L2:	mov		DbleNumber,eax
		}
	}
	// Clear the headers. They are no longer needed.
	//..............................................
	ZeroMemory(&nrphdr,sizeof(nrphdr));
	ZeroMemory(&rphdr,MAX_REPRO_LGTH);
	ZeroMemory(&nrppadhdr,sizeof(nrppadhdr));

	// Open the file we are going to encipher so we can get
	// the file times.
	//.....................................................
	hFileToEncipher = CreateMyFile((LPTSTR)&szFileToEncipher,GENERIC_READ,0,NULL,
								    OPEN_EXISTING,FILE_ATTRIBUTE_NORMAL,NULL);
	if (!hFileToEncipher)
	{
		goto EncipherEnd;
	}
	bResult = GetFileTime(hFileToEncipher,&fip.CREATION,&fip.ACCESSED,&fip.WRITTEN);
	if (!bResult)
	{
		ErrorProcedure((LPTSTR)&szFileToEncipher,IDS_GETFILETIME,MB_OK);
		goto EncipherEnd;
	}
	// Get the file's size for the ckh header.
	//........................................
	ckh.LENGTH.QuadPart = GetMyFileSize((LPTSTR)&szFileToEncipher,hFileToEncipher);
	if (ckh.LENGTH.QuadPart == -1)
	{
		goto EncipherEnd;
	}
	CircleSwap((LPBYTE)&ckh.LENGTH.QuadPart,sizeof(ckh.LENGTH.QuadPart));

	// Free up the memory we do not need any more.
	//............................................
	ZeroMemory(lpKeyBuffer1,SIZE_KEY_BUFF);
	ZeroMemory(lpKeyBuffer2,SIZE_KEY_BUFF);
	ZeroMemory(lpKeyBuffer3,SIZE_KEY_BUFF);
	DeallocateMemory(lpKeyBuffer1);
	lpKeyBuffer1 = 0;
	DeallocateMemory(lpKeyBuffer2);
	lpKeyBuffer2 = 0;
	DeallocateMemory(lpKeyBuffer3);
	lpKeyBuffer3 = 0;

	lpKeyBuffer1 = AllocateMemory(ENC_BUFFER_SIZE);
	if (!lpKeyBuffer1)
	{
		goto EncipherEnd;
	}
	if (dwUseSessionKey == USE_PAD)
	{
		lpKeyBuffer2 = AllocateMemory(ENC_BUFFER_SIZE);
		if (!lpKeyBuffer2)
		{
			goto EncipherEnd;
		}
	}
	// Now we encrypt and write the file info packet.
	//...............................................
	if (dwUseSessionKey != USE_PAD)
	{
		Divisor1 = 256;
		ChangeBytes((LPBYTE)&fip.FILE_NAME,sizeof(fip)-3);
	}
	else
	{
		bResult = ChangeBytesPad((LPBYTE)&fip.FILE_NAME,sizeof(fip)-3,hOtpKeyFile);
		if (!bResult)
		{
			goto EncipherEnd;
		}
	}
	EmptyTheMessageQue();
	if (bCancelOperation == TRUE)
	{
		goto EncipherEnd;
	}
	bResult = WriteMyFile((LPTSTR)&szDestination,hEncryptedFile,
						   &fip,sizeof(fip),&dwBytesWritten,NULL);
	if (!bResult)
	{
		goto EncipherEnd;
	}
	// Clear the file info packet; it is no longer needed.
	//....................................................
	ZeroMemory(&fip,sizeof(fip));

	// Write the ckh header and then encrypt and write the file.
	//..........................................................
	CheckDlgButton(hDialogModeLess,IDC_ENCRYPT4,BST_CHECKED);
	EnableWindow(GetDlgItem(hDialogModeLess,IDC_ENCRYPT5),TRUE);

	bResult = WriteMyFile((LPTSTR)&szDestination,hEncryptedFile,
						   &ckh,sizeof(ckh),&dwBytesWritten,NULL);
	if (!bResult)
	{
		goto EncipherEnd;
	}
	// Go into a loop and encrypt the file.
	//.....................................
	while(TRUE)
	{
		bResult = ReadMyFile((LPTSTR)&szFileToEncipher,hFileToEncipher,
			                  lpKeyBuffer1,ENC_BUFFER_SIZE,&dwBytesRead,NULL);
		if (!bResult)
		{
			goto EncipherEnd;
		}
		// Check for end of file.
		//.......................
		if (dwBytesRead == 0)
		{
			break;
		}
		if (dwUseSessionKey == USE_PAD)
		{
			bResult = ChangeBytesPad(lpKeyBuffer1,dwBytesRead,hOtpKeyFile);
			if (!bResult)
			{
				goto EncipherEnd;
			}
		}
		else
		{	
			ChangeBytes(lpKeyBuffer1,dwBytesRead);
		}
		EmptyTheMessageQue();
		if (bCancelOperation == TRUE)
		{
			goto EncipherEnd;
		}
		bResult = WriteMyFile((LPTSTR)&szDestination,hEncryptedFile,
							   lpKeyBuffer1,dwBytesRead,&dwBytesWritten,NULL);
		if (!bResult)
		{
			goto EncipherEnd;
		}
	}
	if (hEncryptedFile)
	{
		bResult = CloseMyHandle((LPTSTR)&szDestination,hEncryptedFile);
		if (!bResult)
		{
			goto EncipherEnd;
		}
		hEncryptedFile = 0;
	}
	CheckDlgButton(hDialogModeLess,IDC_ENCRYPT5,BST_CHECKED);

	bOutPutError = FALSE;

	// If we used a pad file we have to get the place where we stopped and
	// write this to the header.
	//....................................................................
	if (dwUseSessionKey == USE_PAD)
	{
		while(TRUE)
		{
			bResult = FALSE;
			liPadFreeBytes.QuadPart = 0;
			liPadFreeBytes.QuadPart = SetMyFilePointer((LPTSTR)&szOtpKeyFile,hOtpKeyFile,
													    liPadFreeBytes.QuadPart,FILE_CURRENT);
			if (liPadFreeBytes.QuadPart == -1)
			{
				SetLastError(IDS_UNABLE_TO_SET_START_POINT);
				ErrorProcedure((LPTSTR)&szOtpKeyFile,IDS_SETFILEPOINTER,MB_OK);
				break;
			}
			li.QuadPart = PAD_ID_SIZE;
			li.QuadPart = SetMyFilePointer((LPTSTR)&szOtpKeyFile,hOtpKeyFile,
										    li.QuadPart,FILE_BEGIN);
			if (li.QuadPart == -1)
			{
				SetLastError(IDS_UNABLE_TO_SET_START_POINT);
				ErrorProcedure((LPTSTR)&szOtpKeyFile,IDS_SETFILEPOINTER,MB_OK);
				break;
			}
			bResult = WriteMyFile((LPTSTR)&szOtpKeyFile,hOtpKeyFile,&liPadFreeBytes.QuadPart,
								   sizeof(LARGE_INTEGER),&dwBytesWritten,NULL);
			if (!bResult)
			{
				SetLastError(IDS_UNABLE_TO_SET_START_POINT);
				ErrorProcedure((LPTSTR)&szOtpKeyFile,IDS_SETFILEPOINTER,MB_OK);
				break;
			}
			break;
		}
		if (bResult && !bOutPutError && (cfg.dwWipeAfterUse || bWipeTrueOTPFileAfterUse))
		{
			// Wipe the section of pad file that we used.
			//...........................................
			bResult = WipePadSection((LPTSTR)&szOtpKeyFile,hOtpKeyFile,
									  liStartPosition.QuadPart,liWipeLength.QuadPart);
			if (!bResult)
			{
				SetLastError(IDS_PADOVERWRITEERROR);
				ErrorProcedure((LPTSTR)&szOtpKeyFile,IDS_WIPEPADSECTION,MB_OK);
			}
		}
	}
	// Clear buffers 1 and 2.
	//.......................
	if (lpKeyBuffer1)
	{
		ZeroMemory(lpKeyBuffer1,ENC_BUFFER_SIZE);
		DeallocateMemory(lpKeyBuffer1);
		lpKeyBuffer1 = 0;
	}
	if (lpKeyBuffer2)
	{
		ZeroMemory(lpKeyBuffer2,ENC_BUFFER_SIZE);
		DeallocateMemory(lpKeyBuffer2);
		lpKeyBuffer2 = 0;
	}
	LoadString(hInst,IDS_ENCCOMPLETE,(LPTSTR)&szOutBuffer,sizeof(szOutBuffer));
	SetDlgItemText(hDialogModeLess,IDC_MESSAGE,(LPCTSTR)&szOutBuffer);

	// We are done encrypting the file. Change the cancel button
	// to OK and wait for input.
	//..........................................................
	SetDlgItemText(hDialogModeLess,IDCANCEL,TEXT("&OK"));

	if (uTimer)
	{
		KillTimer(hMainWindow,MY_TIMER);
		uTimer = 0;
	}
	// Flash our task bar icon if it is minimized.
	//............................................
	FlashMyIcon(TRUE);

	while(TRUE)
	{
		CheckForMessages();

		if (bCancelOperation == TRUE)
		{
			bCancelOperation = FALSE;
			DestroyWindow(hDialogModeLess);
			break;
		}
	}

	EncipherEnd:

	if (bCancelOperation == TRUE)
	{
		bCanceledMsgEncryption = TRUE;
	}
	FlashMyIcon(FALSE);

	ZeroMemory(&pkh,sizeof(PKEY_HDR));
	ZeroMemory(&skh,sizeof(SKEY_HDR));
	ZeroMemory(&ckh,sizeof(CKEY_HDR));

	if (hHook)
	{
		UnhookWindowsHookEx(hHook);
		hHook = 0;
	}
	if (hMouseHook)
	{
		UnhookWindowsHookEx(hMouseHook);
		hMouseHook = 0;
	}
	if (hDialogModeLess)
	{
		DestroyWindow(hDialogModeLess);
	}
	if (uTimer)
	{
		KillTimer(hMainWindow,MY_TIMER);
		uTimer = 0;
	}
	// Reset the status bar to ready or the name of the key rings.
	//............................................................
	if (bDisplayRingsOnStatusBar)
	{
		SendMessage(hStatusBar,SB_SETTEXT,0,(LPARAM)szStatusBarRings);
	}
	else
	{
		LoadString(hInst,IDS_READY,szOutBuffer,sizeof(szOutBuffer));
		SendMessage(hStatusBar,SB_SETTEXT,0,(LPARAM)szOutBuffer);
	}

	if (lpKeyBuffer1)
	{
		ZeroMemory(lpKeyBuffer1,SIZE_KEY_BUFF);
		DeallocateMemory(lpKeyBuffer1);
		lpKeyBuffer1 = 0;
	}
	if (lpKeyBuffer2)
	{
		ZeroMemory(lpKeyBuffer2,SIZE_KEY_BUFF);
		DeallocateMemory(lpKeyBuffer2);
		lpKeyBuffer2 = 0;
	}
	if (lpKeyBuffer3)
	{
		ZeroMemory(lpKeyBuffer3,SIZE_KEY_BUFF);
		DeallocateMemory(lpKeyBuffer3);
		lpKeyBuffer3 = 0;
	}
	if (lpSecretKeyCentralDir)
	{
		ZeroMemory(lpSecretKeyCentralDir,(dwSecretIds * sizeof(CD_STRUCT)));
		DeallocateMemory(lpSecretKeyCentralDir);
		lpSecretKeyCentralDir = 0;
	}
	if (lpPublicKeyCentralDir)
	{
		ZeroMemory(lpPublicKeyCentralDir,(dwPublicIds * sizeof (CD_STRUCT)));
		DeallocateMemory(lpPublicKeyCentralDir);
		lpPublicKeyCentralDir = 0;
	}
	// Wipe out any evidence we may have from using the keys.
	//.......................................................
	ClearAllVariables();
	ZeroMemory(&szPassPhrase1,sizeof(szPassPhrase1));

	if (hFileToEncipher)
	{
		CloseMyHandle((LPTSTR)&szFileToEncipher,hFileToEncipher);
	}
	if (hEncryptedFile)
	{
		CloseMyHandle((LPTSTR)&szDestination,hEncryptedFile);
		
		// If we had an output error, delete the file.
		//............................................
		if (bOutPutError)
		{
			WipeMyFile((LPTSTR)&szDestination,TRUE);
		}
	}
	// Wipe the intermediate packed file.
	//...................................
	if (!bOutPutError && bIntermediatePkd && bWipeIntermediate)
	{
		WipeMyFile((LPBYTE)&szFileToEncipher,TRUE);
		bIntermediatePkd = FALSE;
		bWipeIntermediate = FALSE;
	}
	// Wipe the original files after encryption.
	//..........................................
	if (bWipeAfterEncryption && !lpBuffer && !bOutPutError)
	{
		bWipeFiles = TRUE;
		bCancelOperation = FALSE;
		DeleteWipeFiles(lpFileReturn,&ofnEncrypt);
		bWipeAfterEncryption = FALSE;
	}
	if (!lpBuffer && lpFileReturn)
	{
		ZeroMemory(lpFileReturn,((64*1024)-1));
		DeallocateMemory(lpFileReturn);
	}
	if (hOtpKeyFile)
	{
		CloseMyHandle((LPTSTR)&szOtpKeyFile,hOtpKeyFile);
	}
	// Wipe the OTP Key File if we used one and we want to wipe it.
	//.............................................................
	if (dwUseSessionKey == USE_KEY && !bOutPutError && 
	   (cfg.dwWipeAfterUse || bWipeOTPFileAfterUse))
	{
		ConfirmWipeMyFile(IDS_CONFIRMWIPE,(LPBYTE)&szOtpKeyFile,TRUE);
	}
	ChangeHelpTopic(dwOldHelpTopic);
	bCancelOperation = FALSE;
	bWipeOTPFileAfterUse = FALSE;
	bWipeTrueOTPFileAfterUse = FALSE;
	bWipeAfterEncryption = FALSE;

	if (!lpBuffer)
	{
		bProcessInProgress = FALSE;
	}
	return(bOutPutError);
}

// Special hook for open file dialog for encrypting a file.
// Adds a wipe after encryption checkbox.
//.........................................................
UINT CALLBACK MyEncOFNHookProc(HWND hDlg, UINT uiMsg, WPARAM wParam, LPARAM lParam)
{
	static HWND		hWndParent;
	UINT			uCheck;
	LPHELPINFO		lphi;

	switch (uiMsg)
	{
		case WM_INITDIALOG:
		{
			bShowPreviousEncFolder = FALSE;
			CheckDlgButton(hDlg,IDC_WIPEINTERPKD,BST_CHECKED);
			hWndParent = GetParent(hDlg);
			SetMyIcon(hWndParent);
			CenterWindow(hWndParent,hMainWindow);
			return(TRUE);
		}

		case WM_COMMAND:
		{
			switch(LOWORD(wParam))
			{
				case IDC_WIPEAFTERENC:
				{
					uCheck = IsDlgButtonChecked(hDlg,IDC_WIPEAFTERENC);
					if (uCheck == BST_CHECKED)
					{
						uCheck = BST_UNCHECKED;
						bWipeAfterEncryption = FALSE;
					}
					else
					{
						uCheck = BST_CHECKED;
						bWipeAfterEncryption = TRUE;
					}
					CheckDlgButton(hDlg,IDC_WIPEAFTERENC,uCheck);
				}
				break;

				case IDC_USE_ENC_FOLDER:
				{
					uCheck = IsDlgButtonChecked(hDlg,IDC_USE_ENC_FOLDER);
					if (uCheck == BST_CHECKED)
					{
						uCheck = BST_UNCHECKED;
						bShowPreviousEncFolder = FALSE;
					}
					else
					{
						uCheck = BST_CHECKED;
						bShowPreviousEncFolder = TRUE;
					}
					CheckDlgButton(hDlg,IDC_USE_ENC_FOLDER,uCheck);
				}
				break;

				case IDC_WIPEINTERPKD:
				{
					uCheck = IsDlgButtonChecked(hDlg,IDC_WIPEINTERPKD);
					if (uCheck == BST_CHECKED)
					{
						uCheck = BST_UNCHECKED;
						bWipeIntermediate = FALSE;
					}
					else
					{
						uCheck = BST_CHECKED;
						bWipeIntermediate = TRUE;
					}
					CheckDlgButton(hDlg,IDC_WIPEINTERPKD,uCheck);
				}
				break;
			}
		}
		break;

		case WM_HELP:
		{
			lphi = (LPHELPINFO)lParam;
			if (lphi->iContextType == HELPINFO_WINDOW)
			{
				if (lphi->iCtrlId == IDC_WIPEAFTERENC || lphi->iCtrlId == IDC_WIPEINTERPKD ||
					lphi->iCtrlId == IDC_USE_ENC_FOLDER)
				{
					PopupHelp(hDlg,lParam);
					return(TRUE);
				}
			}
		}
		break;

		case WM_CONTEXTMENU:
		{
			WhatsThis(hDlg,(HWND)wParam,lParam);
		}
		break;
	}
	return(FALSE);
}

// Special hook for open file dialog for One Time Pad Key File.
// Adds a wipe after use check box.
//.............................................................
UINT CALLBACK MyOTPOFNHookProc(HWND hDlg, UINT uiMsg, WPARAM wParam, LPARAM lParam)
{
	static HWND		hWndParent;
	UINT			uCheck;
	LPHELPINFO		lphi;

	switch (uiMsg)
	{
		case WM_INITDIALOG:
		{
			hWndParent = GetParent(hDlg);
			SetMyIcon(hWndParent);
			CenterWindow(hWndParent,hMainWindow);
			return(TRUE);
		}

		case WM_COMMAND:
		{
			switch(LOWORD(wParam))
			{
				case IDC_WIPEOTPKEYFILE:
				{
					uCheck = IsDlgButtonChecked(hDlg,IDC_WIPEOTPKEYFILE);
					if (uCheck == BST_CHECKED)
					{
						uCheck = BST_UNCHECKED;
						bWipeOTPFileAfterUse = FALSE;
					}
					else
					{
						uCheck = BST_CHECKED;
						bWipeOTPFileAfterUse = TRUE;
					}
					CheckDlgButton(hDlg,IDC_WIPEOTPKEYFILE,uCheck);
				}
				break;
			}
		}
		break;

		case WM_HELP:
		{
			lphi = (LPHELPINFO)lParam;
			if (lphi->iContextType == HELPINFO_WINDOW)
			{
				if (lphi->iCtrlId == IDC_WIPEOTPKEYFILE)
				{
					PopupHelp(hDlg,lParam);
					return(TRUE);
				}
			}
		}
		break;

		case WM_CONTEXTMENU:
		{
			WhatsThis(hDlg,(HWND)wParam,lParam);
		}
		break;
	}
	return(FALSE);
}

// Special hook for open file dialog for True One Time Pad File.
// Adds a wipe after use check box.
//..............................................................
UINT CALLBACK MyTrueOFNHookProc(HWND hDlg, UINT uiMsg, WPARAM wParam, LPARAM lParam)
{
	static HWND		hWndParent;
	UINT			uCheck;
	LPHELPINFO		lphi;

	switch (uiMsg)
	{
		case WM_INITDIALOG:
		{
			hWndParent = GetParent(hDlg);
			SetMyIcon(hWndParent);
			CenterWindow(hWndParent,hMainWindow);
			return(TRUE);
		}

		case WM_COMMAND:
		{
			switch(LOWORD(wParam))
			{
				case IDC_WIPETRUEOTP:
				{
					uCheck = IsDlgButtonChecked(hDlg,IDC_WIPETRUEOTP);
					if (uCheck == BST_CHECKED)
					{
						uCheck = BST_UNCHECKED;
						bWipeTrueOTPFileAfterUse = FALSE;
					}
					else
					{
						uCheck = BST_CHECKED;
						bWipeTrueOTPFileAfterUse = TRUE;
					}
					CheckDlgButton(hDlg,IDC_WIPETRUEOTP,uCheck);
				}
				break;
			}
		}
		break;

		case WM_HELP:
		{
			lphi = (LPHELPINFO)lParam;
			if (lphi->iContextType == HELPINFO_WINDOW)
			{
				if (lphi->iCtrlId == IDC_WIPETRUEOTP)
				{
					PopupHelp(hDlg,lParam);
					return(TRUE);
				}
			}
		}
		break;

		case WM_CONTEXTMENU:
		{
			WhatsThis(hDlg,(HWND)wParam,lParam);
		}
		break;
	}
	return(FALSE);
}

// Dialog box for asking what type of session key we want to use.
//...............................................................
LRESULT CALLBACK AskSessionKeyProc(HWND hDlg, UINT uiMsg, WPARAM wParam, LPARAM lParam)
{
	switch(uiMsg)
	{
		case WM_INITDIALOG:
		{
			// Setup the icon to use in the caption bar.
			//..........................................
			lpIconPointer = lpszAppName;
			SetMyIcon(hDlg);

			// Let find the icon for the file.
			//................................
			hIcon = FindMyIcon((LPBYTE)&szFileToEncipher,lpFileExtension);

			// If we did not find one, use the default.
			//.........................................
			if (!hIcon)
			{
				hIcon = LoadImage(hInst,"I_FACEFROWN",IMAGE_ICON,32,32,LR_SHARED);
			}
			if (hIcon)
			{
				SendMessage(GetDlgItem(hDlg,IDC_ICON1),STM_SETICON,(WPARAM)hIcon,0);
			}
			// If we are encrypting an e-mail message, change the header for
			// the dialog box.
			//..............................................................
			if (bEncryptingEmail)
			{
				SetWindowText(hDlg,TEXT("Encipher an E-mail Message"));
			}
			// Setup the name of the file to encipher.
			//........................................
			SetDlgItemTextFmt(hDlg,IDC_STATEMENT1,
							 (LPCTSTR)GetDisplayName(&shfi1,(LPCTSTR)&szFileToEncipher));

			// Setup the name of the recipient.
			//.................................
			SetDlgItemTextFmt(hDlg,IDC_RECIPIENT,(LPCTSTR)&szRecipient);

			// Center the window.
			//...................
			CenterWindow(hDlg,GetWindow(hDlg,GW_OWNER));
			return(TRUE);
		}

		case WM_COMMAND:
		{
			switch (LOWORD(wParam))
			{
				case IDC_OTPKEY:
				{
					CheckRadioButton(hDlg,IDC_SESSIONKEY,IDC_TRUEPAD,IDC_OTPKEY);
					dwUseSessionKey = USE_KEY;
				}
				break;

				case IDC_SESSIONKEY:
				{
					CheckRadioButton(hDlg,IDC_SESSIONKEY,IDC_TRUEPAD,IDC_SESSIONKEY);
					dwUseSessionKey = USE_RANDOM;
				}
				break;

				case IDC_TRUEPAD:
				{
					CheckRadioButton(hDlg,IDC_SESSIONKEY,IDC_TRUEPAD,IDC_TRUEPAD);
					dwUseSessionKey = USE_PAD;
				}
				break;

				case IDOK:
				{
					EndDialog(hDlg,IDOK);
				}
				break;

				case IDCANCEL:
				{
					EndDialog(hDlg,IDCANCEL);
				}
				break;

				case IDC_MYHELP:
				{
					DisplayMyHelp(hDlg);
				}
				break;
			}
			break;
		}

		case WM_HELP:
		{
			PopupHelp(hDlg,lParam);
		}
		break;

		case WM_CONTEXTMENU:
		{
			WhatsThis(hDlg,(HWND)wParam,lParam);
		}
		break;
	
		default:
			return(FALSE);
	}
	return(TRUE);
}

// Dialog box for asking for special instruction to follow before
// a file is decrypted.								   
//...............................................................
LRESULT CALLBACK GetSpecialInstructionsProc(HWND hDlg, UINT uiMsg, WPARAM wParam, 
											LPARAM lParam)
{
	int		i;

	switch(uiMsg)
	{
		case WM_INITDIALOG:
		{
			// Setup the icon to use in the caption bar.
			//..........................................
			lpIconPointer = lpszAppName;
			SetMyIcon(hDlg);

			hSpecialInst = GetDlgItem(hDlg,IDC_SPECIAL);
			SetBoldFont(hDlg,IDC_SPECIAL,0);

			// Let find the icon for the file.
			//................................
			hIcon = FindMyIcon((LPBYTE)&szFileToEncipher,lpFileExtension);

			// If we did not find one, use the default.
			//.........................................
			if (!hIcon)
			{
				hIcon = LoadImage(hInst,"I_FACEFROWN",IMAGE_ICON,32,32,LR_SHARED);
			}
			if (hIcon)
			{
				SendMessage(GetDlgItem(hDlg,IDC_ICON1),STM_SETICON,(WPARAM)hIcon,0);
			}
			// Setup the name of the file to encipher.
			//........................................
			SetDlgItemTextFmt(hDlg,IDC_STATEMENT1,
							 (LPCTSTR)GetDisplayName(&shfi1,(LPCTSTR)&szFileToEncipher));

			// Clear the special instructions field and set the text
			// limit.
			//......................................................
			fip.INSTRUCTION_LENGTH = 0;
			ZeroMemory(&fip.INSTRUCTIONS,sizeof(fip.INSTRUCTIONS));

			// Set the list of default classifications in the combo box.
			//..........................................................
			for (i = 0; i < CLASSIFICATIONS; i++)
			{
				SendMessage(hSpecialInst,CB_ADDSTRING,0,(LPARAM)lpClassifications[i]);
			}
			SendDlgItemMessage(hDlg,IDC_SPECIAL,CB_LIMITTEXT ,
							  (WPARAM)sizeof(fip.INSTRUCTIONS),0);

			// Center the window.
			//...................
			CenterWindow(hDlg,GetWindow(hDlg,GW_OWNER));
			return(TRUE);
		}

		case WM_CTLCOLOREDIT:
		{
			SetTextColor((HDC)wParam,crClassification);
			SetBkColor((HDC)wParam,RGB(255,255,255));
			return((BOOL)GetStockObject(WHITE_BRUSH));
		}
		break;

		case WM_COMMAND:
		{
			switch (LOWORD(wParam))
			{
				case IDC_SPECIAL:
				{
					if (HIWORD(wParam) == CBN_SELCHANGE)
					{
						dwSelection = SendMessage(hSpecialInst,CB_GETCURSEL,0,0);
						if (dwSelection != CB_ERR)
						{
							if (dwSelection <= 2)
							{
								crClassification = RGB(255,128,0);
							}
							else if (dwSelection == 3)
							{
								crClassification = RGB(255,0,0);
							}
							else if (dwSelection == 4)
							{
								crClassification = RGB(0,0,255);
							}
							else if (dwSelection == 5)
							{
								crClassification = RGB(128,0,128);
							}
							else if (dwSelection == 6)
							{
								crClassification = RGB(0,128,0);
							}
						}
						else
						{
							crClassification = RGB(0,0,0);
						}
						SetFocus(GetDlgItem(hDlg,IDOK));
					}
					else if (HIWORD(wParam) == CBN_EDITUPDATE)
					{
						crClassification = RGB(0,0,0);
					}
				}
				break;

				case IDOK:
				{
					GetDlgItemText(hDlg,IDC_SPECIAL,(LPTSTR)&fip.INSTRUCTIONS,
								   sizeof(fip.INSTRUCTIONS));
					fip.INSTRUCTION_LENGTH = lstrlen((LPCTSTR)&fip.INSTRUCTIONS);

					if (hDlgFont)
					{
						DeleteObject(hDlgFont);
						hDlgFont = 0;
					}
					EndDialog(hDlg,IDOK);
				}
				break;

				case IDCANCEL:
				{
					if (hDlgFont)
					{
						DeleteObject(hDlgFont);
						hDlgFont = 0;
					}
					EndDialog(hDlg,IDCANCEL);
				}
				break;

				case IDC_MYHELP:
				{
					DisplayMyHelp(hDlg);
				}
				break;
			}
			break;
		}

		case WM_HELP:
		{
			PopupHelp(hDlg,lParam);
		}
		break;

		case WM_CONTEXTMENU:
		{
			WhatsThis(hDlg,(HWND)wParam,lParam);
		}
		break;
	
		default:
			return(FALSE);
	}
	return(TRUE);
}

// CALLBACK procedure for the file encryption dialog box.
//.......................................................
LRESULT CALLBACK EncryptAFileProc(HWND hDlg, UINT uiMsg, WPARAM wParam, LPARAM lParam)
{
	switch(uiMsg)
	{
		case WM_INITDIALOG:
		{
			TCHAR		szBuffer[128];

			// Setup the icon to use in the caption bar.
			//..........................................
			lpIconPointer = lpszAppName;
			SetMyIcon(hDlg);

			SetBoldFont(hDlg,IDC_MESSAGE,0);

			// Find the icon of the file we are encrypting.
			//.............................................
			hIcon = FindMyIcon((LPBYTE)&szFileToEncipher,lpFileExtension);

			// If we did not find one, use the default.
			//.........................................
			if (!hIcon)
			{
				hIcon = LoadImage(hInst,"I_FACEFROWN",IMAGE_ICON,32,32,LR_SHARED);
			}
			if (hIcon)
			{
				SendMessage(GetDlgItem(hDlg,IDC_ICON1),STM_SETICON,(WPARAM)hIcon,0);
			}
			// Setup the name of the file to encipher.
			//........................................
			SetDlgItemTextFmt(hDlg,IDC_FILE1,
							 (LPCTSTR)GetDisplayName(&shfi1,(LPCTSTR)&szFileToEncipher));

			// Setup the name of the encrypted file.
			//......................................
			SetDlgItemTextFmt(hDlg,IDC_FILE2,
							 (LPCTSTR)GetDisplayName(&shfi2,(LPCTSTR)&szDestination));

			// If we are using the Sha algorithm change text for the checkbox.
			//................................................................
			if (!bUseMd5)
			{
				if (skh.MD5_ALGOR == SHA_ALGORITHM)
				{
					LoadString(hInst,IDS_ENC_SHA,(LPTSTR)&szBuffer,sizeof(szBuffer));
				}
				else
				{
					LoadString(hInst,IDS_ENC_SHA512,(LPTSTR)&szBuffer,sizeof(szBuffer));
				}
				SetWindowText(GetDlgItem(hDlg,IDC_ENCRYPT2),(LPCTSTR)&szBuffer);
			}
			CenterWindow(hDlg,GetWindow(hDlg,GW_OWNER));
			SetFocus(GetDlgItem(hDlg,IDCANCEL));
			return(FALSE);
		}

		case WM_ACTIVATE:
		{
			if (wParam == 0)
			{
				hDlgCurrent = NULL;
			}
			else
			{
				hDlgCurrent = hDlg;
			}
			return(FALSE);
		}

		case WM_COMMAND:
		{
			switch (LOWORD(wParam))
			{
				// Inform the procedure that we want to quit.
				//...........................................
				case IDCANCEL:
				{
					bCancelOperation = TRUE;
				}
				break;
			}
		}
		break;

		case WM_DESTROY:
		{
			if (hDlgFont)
			{
				DeleteObject(hDlgFont);
				hDlgFont = 0;
			}
			hDialogModeLess = NULL;
		}
		break;

		default:
			return(FALSE);
	}
	return(TRUE);
}

// ChangeBytes will either encipher or decipher the contents
// of the buffer.
//..........................................................
VOID ChangeBytes(LPBYTE lpChangeBuffer, DWORD dwBytesToChange)
{
	LPBYTE		lpChangeBufferDup;
	DWORD		dwRandomNumber;

	lpChangeBufferDup = lpChangeBuffer;

	while(dwBytesToChange > 0)
	{
		CheckForMessages();
		if (bCancelOperation == TRUE)
		{
			return;
		}
		// Get a pseudo random number in the range 0 to 255.
		//..................................................
		dwRandomNumber = GetRandomNumber();

		__asm
		{
			mov		edi,lpChangeBufferDup
			mov		eax,dwRandomNumber
			xor		byte ptr [edi],al
			not		byte ptr [edi]
			inc		lpChangeBufferDup
			dec		dwBytesToChange
		}
	}
}

// ChangeBytesPad will either encipher or decipher the contents
// of the buffer. Use lpKeyBuffer2 for the pad file.
//.............................................................
BOOL ChangeBytesPad(LPBYTE lpChangeBuffer, DWORD dwBytesToChange, HANDLE hFile)
{
	DWORD		dwBytesRead;
	BOOL		bResult;

	// Read in the number of random bytes required from the pad file.
	//...............................................................
	bResult = ReadMyFile((LPTSTR)&szOtpKeyFile,hFile,lpKeyBuffer2,dwBytesToChange,
						  &dwBytesRead,NULL);
	if (!bResult)
	{
		return(bResult);
	}
	CheckForMessages();
	if (bCancelOperation == TRUE)
	{
		return(FALSE);
	}
	// Encrypt the buffer.
	//....................
	__asm
	{
		mov		esi,lpChangeBuffer
		mov		edi,lpKeyBuffer2
		mov		ecx,dwBytesToChange
	L1:	mov		al,byte ptr [edi]
		xor		byte ptr [esi],al
		not		byte ptr [esi]
		inc		esi
		inc		edi
		dec		ecx
		jnz		L1
	}
	return(TRUE);
}
